/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.navigator.CommonViewer;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.PackagesUIPlugin;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;
import org.jboss.ide.eclipse.archives.ui.views.ProjectArchivesCommonView;
import org.jboss.ide.eclipse.archives.ui.wizards.WizardPageWithNotification;
import org.jboss.ide.eclipse.archives.ui.wizards.WizardWithNotification;
import org.jboss.ide.eclipse.archives.ui.wizards.pages.ArchiveInfoWizardPage;

public abstract class AbstractArchiveWizard
extends WizardWithNotification
implements INewWizard {
    private ArchiveInfoWizardPage firstPage;
    private WizardPage[] pages;
    protected IProject project;
    protected IArchive existingPackage;
    protected String initialDestinationPath;
    protected boolean isPathWorkspaceRelative;
    protected IArchiveNode initialDestinationNode;

    public AbstractArchiveWizard() {
    }

    public AbstractArchiveWizard(IArchive existingPackage) {
        this.existingPackage = existingPackage;
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(existingPackage.getProjectName());
    }

    public void addPages() {
        this.firstPage = new ArchiveInfoWizardPage(this, this.existingPackage);
        this.addPage(this.firstPage);
        this.pages = this.createWizardPages();
        int i = 0;
        while (i < this.pages.length) {
            this.addPage((IWizardPage)this.pages[i]);
            ++i;
        }
    }

    public boolean canFinish() {
        if (this.firstPage.isPageComplete()) {
            int i = 0;
            while (i < this.pages.length) {
                if (!this.pages[i].isPageComplete()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean performFinish() {
        IWizardPage[] allPages = this.getPages();
        int i = 0;
        while (i < allPages.length) {
            if (allPages[i] instanceof WizardPageWithNotification) {
                ((WizardPageWithNotification)allPages[i]).pageExited(3);
            }
            ++i;
        }
        final boolean create = this.existingPackage == null;
        final IArchive pkg = this.firstPage.getArchive();
        boolean performed = this.performFinish(pkg);
        if (performed) {
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IArchiveNode parent;
                        IArchiveNode destNode = AbstractArchiveWizard.this.firstPage.getDestinationNode();
                        if (destNode != null) {
                            if (!create && !destNode.equals(pkg.getParent()) && pkg.getParent() != null) {
                                pkg.getParent().removeChild((IArchiveNode)pkg);
                            }
                            parent = destNode;
                        } else {
                            parent = ArchivesModel.instance().getRoot(AbstractArchiveWizard.this.project.getLocation());
                            if (parent == null) {
                                parent = ArchivesModel.instance().registerProject(AbstractArchiveWizard.this.project.getLocation(), null);
                            }
                        }
                        try {
                            if (create) {
                                parent.addChild((IArchiveNode)pkg);
                            }
                            ArchivesModel.instance().getRoot(AbstractArchiveWizard.this.project.getLocation()).save(monitor);
                        }
                        catch (ArchivesModelException ame) {
                            Status status = new Status(4, "org.jboss.ide.eclipse.archives.ui", ArchivesUIMessages.ErrorCompletingWizard, (Throwable)ame);
                            PackagesUIPlugin.getDefault().getLog().log((IStatus)status);
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return performed;
    }

    private IStructuredSelection getArchivesViewSelection() {
        CommonViewer cv;
        ProjectArchivesCommonView view = ProjectArchivesCommonView.getInstance();
        if (view != null && (cv = view.getCommonViewer()) != null) {
            ISelection sel = cv.getSelection();
            return sel instanceof IStructuredSelection ? (IStructuredSelection)sel : null;
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IStructuredSelection fromArchivesView = this.getArchivesViewSelection();
        selection = selection == null ? fromArchivesView : selection;
        this.init(selection);
        if (this.initialDestinationPath == null && this.initialDestinationNode == null && (selection = fromArchivesView) != null) {
            this.init(selection);
        }
        this.setNeedsProgressMonitor(true);
    }

    private void init(IStructuredSelection selection) {
        Object selected;
        this.project = null;
        Object object = selected = selection.isEmpty() ? this.project : selection.getFirstElement();
        if (selected instanceof IArchiveNode) {
            IArchiveNode node = (IArchiveNode)selected;
            if (node.getNodeType() == 0 || node.getNodeType() == 3) {
                this.initialDestinationNode = (IArchiveNode)selected;
            }
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(node.getProjectName());
        } else if (selected instanceof IContainer) {
            this.project = ((IContainer)selected).getProject();
            this.initialDestinationPath = ((IContainer)selected).getFullPath().toString();
            this.isPathWorkspaceRelative = true;
        } else if (selected instanceof ArchivesContentProviderDelegate.WrappedProject) {
            this.project = ((ArchivesContentProviderDelegate.WrappedProject)selected).getElement();
            this.initialDestinationPath = this.project.getFullPath().toString();
            this.isPathWorkspaceRelative = true;
        } else {
            this.project = ProjectArchivesCommonView.getInstance().getCurrentProject();
            if (this.project != null) {
                this.initialDestinationPath = this.project.getFullPath().toString();
                this.isPathWorkspaceRelative = true;
            }
        }
    }

    public IArchiveNode getInitialNode() {
        return this.initialDestinationNode;
    }

    public String getInitialPath() {
        return this.initialDestinationPath;
    }

    public boolean isInitialPathWorkspaceRelative() {
        return this.isPathWorkspaceRelative;
    }

    public IProject getProject() {
        return this.project;
    }

    public IArchive getArchive() {
        return this.firstPage.getArchive();
    }

    public abstract boolean performFinish(IArchive var1);

    public abstract WizardPage[] createWizardPages();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract String getArchiveExtension();
}

