/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopAction;
import org.eclipse.wst.server.ui.internal.wizard.NewServerWizard;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.actions.ServerActionMessages;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.FullPublishJobScheduler;

public class SelectServerActionDelegate
implements IWorkbenchWindowPulldownDelegate {
    protected IWorkbenchWindow window;
    private boolean isInitialized = false;
    private Image startImage = ImageResource.getImageDescriptor((String)"IMG_ELCL_START").createImage();
    private Image debugImage = ImageResource.getImageDescriptor((String)"IMG_ELCL_START_DEBUG").createImage();
    private Image profileImage = ImageResource.getImageDescriptor((String)"IMG_ELCL_START_PROFILE").createImage();
    private Image stopImage = ImageResource.getImageDescriptor((String)"IMG_ELCL_STOP").createImage();
    private Image publishImage = ImageResource.getImageDescriptor((String)"IMG_ELCL_PUBLISH").createImage();
    private Map<String, Image> imageMap = new HashMap<String, Image>();

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.loadServers();
    }

    private void loadServers() {
        new Thread("Loading Server Adapters"){

            @Override
            public void run() {
                ServerCore.getServers();
                SelectServerActionDelegate.this.setInitialized(true);
            }
        }.start();
    }

    private void setInitialized(boolean status) {
        this.isInitialized = status;
    }

    public void run(IAction action) {
        if (!this.isInitialized) {
            this.loadServers();
        } else {
            this.doRun();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void doRun() {
        this.getMenu((Control)this.window.getShell()).setVisible(true);
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        if (this.isInitialized) {
            IServer[] servers = ServerCore.getServers();
            int i = 0;
            while (i < servers.length) {
                this.createServerItem(menu, servers[i]);
                ++i;
            }
            new MenuItem(menu, 2);
            this.createNewServerItem(menu);
        } else {
            MenuItem item = new MenuItem(menu, 16);
            item.setText("Loading...");
            item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        }
        return menu;
    }

    private void createServerItem(Menu menu, final IServer server) {
        Menu serverMenu = new Menu(menu);
        MenuItem serverItem = new MenuItem(menu, 64);
        serverItem.setText(server.getName());
        serverItem.setMenu(serverMenu);
        MenuItem start = new MenuItem(serverMenu, 0);
        start.setText("Start");
        start.setImage(this.startImage);
        MenuItem debugStart = new MenuItem(serverMenu, 0);
        debugStart.setText("Debug");
        debugStart.setImage(this.debugImage);
        MenuItem profileStart = new MenuItem(serverMenu, 0);
        profileStart.setText("Profile");
        profileStart.setImage(this.profileImage);
        if (server.getServerState() == 2) {
            start.setText("Restart");
            debugStart.setText("Restart in Debug");
            profileStart.setText("Restart in Profile");
        }
        new MenuItem(serverMenu, 2);
        MenuItem stop = new MenuItem(serverMenu, 0);
        stop.setText("Stop");
        stop.setImage(this.stopImage);
        new MenuItem(serverMenu, 2);
        MenuItem publish = new MenuItem(serverMenu, 0);
        publish.setText("Publish (Incremental)");
        publish.setImage(this.publishImage);
        MenuItem fullPublish = new MenuItem(serverMenu, 0);
        fullPublish.setText("Publish (Full)");
        fullPublish.setImage(this.publishImage);
        start.setEnabled(server.canStart("run").isOK());
        debugStart.setEnabled(server.canStart("debug").isOK());
        profileStart.setEnabled(server.canStart("profile").isOK());
        stop.setEnabled(server.canStop().isOK());
        publish.setEnabled(server.canPublish().isOK());
        fullPublish.setEnabled(server.canPublish().isOK());
        start.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartAction.start((IServer)server, (String)"run", (Shell)SelectServerActionDelegate.this.window.getShell());
            }
        });
        debugStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartAction.start((IServer)server, (String)"debug", (Shell)SelectServerActionDelegate.this.window.getShell());
            }
        });
        profileStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartAction.start((IServer)server, (String)"profile", (Shell)SelectServerActionDelegate.this.window.getShell());
            }
        });
        stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StopAction.stop((IServer)server, (Shell)SelectServerActionDelegate.this.window.getShell());
            }
        });
        publish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishAction.publish((IServer)server, (Shell)SelectServerActionDelegate.this.window.getShell());
            }
        });
        fullPublish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new FullPublishJobScheduler(server, server.getModules()).schedule();
            }
        });
        serverItem.setImage(this.getImage(server.getServerType()));
    }

    private Image getImage(IServerType st) {
        ImageDescriptor i;
        if (st == null || st.getId() == null) {
            return null;
        }
        if (this.imageMap.get(st.getId()) == null && (i = ImageResource.getImageDescriptor((String)st.getId())) != null) {
            this.imageMap.put(st.getId(), i.createImage());
        }
        return this.imageMap.get(st.getId());
    }

    private void createNewServerItem(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(ServerActionMessages.SelectServerActionDelegate_NewServerMenuItem);
        item.setImage(JBossServerUISharedImages.getImage("GENERIC_SERVER_IMAGE"));
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectServerActionDelegate.this.newServer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectServerActionDelegate.this.newServer();
                this.widgetSelected(e);
            }
        });
    }

    private void newServer() {
        NewServerWizard wizard = new NewServerWizard();
        WizardDialog dialog = new WizardDialog(this.window.getShell(), (IWizard)wizard);
        dialog.open();
    }

    public void dispose() {
        Iterator<Image> images = this.imageMap.values().iterator();
        while (images.hasNext()) {
            images.next().dispose();
        }
    }
}

