/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.ui.editor.internal.DelayedServerWorkingCopy;

public class DeploymentTypeUIUtil {
    public static IDeploymentTypeUI.IServerModeUICallback getCallback(TaskModel tm, IWizardHandle handle, ICompletable completable) {
        return DeploymentTypeUIUtil.getCallback(tm, handle, completable, true);
    }

    public static IDeploymentTypeUI.IServerModeUICallback getCallback(TaskModel tm, IWizardHandle handle, ICompletable completable, boolean persistImmediately) {
        if (persistImmediately) {
            return new NewServerWizardBehaviourCallback(tm, handle, completable);
        }
        return new EditServerWizardBehaviourCallback(tm, handle, completable);
    }

    public static ServerEditorUICallback getCallback(IServerWorkingCopy server, IEditorInput input, ServerEditorPart part, ServerEditorSection section) {
        return new ServerEditorUICallback(input, part, section);
    }

    public static class EditServerWizardBehaviourCallback
    extends NewServerWizardBehaviourCallback
    implements IDeploymentTypeUI.IServerModeUICallback {
        private ArrayList<IUndoableOperation> list = new ArrayList();
        private DelayedServerWorkingCopy delayed;

        public EditServerWizardBehaviourCallback(TaskModel tm, IWizardHandle handle, ICompletable completable) {
            super(tm, handle, completable);
        }

        @Override
        public IServerWorkingCopy getServer() {
            if (this.delayed == null) {
                this.delayed = new DelayedServerWorkingCopy(super.getServer());
            }
            return this.delayed;
        }

        public void performFinish() {
            Iterator<IUndoableOperation> undoable = this.list.iterator();
            while (undoable.hasNext()) {
                try {
                    undoable.next().execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException ee) {
                    JBossServerUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ui", 0, ee.getMessage(), (Throwable)ee));
                }
            }
        }
    }

    public static interface ICompletable {
        public void setComplete(boolean var1);
    }

    public static class NewServerWizardBehaviourCallback
    implements IDeploymentTypeUI.IServerModeUICallback {
        protected TaskModel tm;
        protected IWizardHandle handle;
        protected ICompletable completable;

        public NewServerWizardBehaviourCallback(TaskModel tm, IWizardHandle handle, ICompletable completable) {
            this.tm = tm;
            this.handle = handle;
            this.completable = completable;
        }

        @Override
        public IRuntime getRuntime() {
            return (IRuntime)this.tm.getObject("runtime");
        }

        @Override
        public IServerWorkingCopy getServer() {
            return (IServerWorkingCopy)this.tm.getObject("server");
        }

        public IWizardHandle getHandle() {
            return this.handle;
        }

        @Override
        public void execute(IUndoableOperation operation) {
            try {
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }

        @Override
        public void executeLongRunning(Job j) {
            j.schedule();
        }

        @Override
        public void setErrorMessage(String msg) {
            this.setComplete(msg != null);
            this.handle.setMessage(msg, 3);
            this.handle.update();
        }

        @Override
        public Object getAttribute(String key) {
            return this.tm.getObject(key);
        }

        @Override
        public int getCallbackType() {
            return 1;
        }

        @Override
        public void setComplete(boolean complete) {
            if (this.completable != null) {
                this.completable.setComplete(complete);
            }
        }
    }

    public static class ServerEditorUICallback
    implements IDeploymentTypeUI.IServerModeUICallback {
        private ServerResourceCommandManager commandManager;
        private ServerEditorPart part;
        private ServerEditorSection section;
        private IEditorInput input;

        public ServerEditorUICallback(IEditorInput input, ServerEditorPart part, ServerEditorSection section) {
            this.part = part;
            this.section = section;
            this.input = input;
            this.commandManager = ((ServerEditorPartInput)input).getServerCommandManager();
        }

        @Override
        public IServerWorkingCopy getServer() {
            return this.part.getServer();
        }

        @Override
        public void execute(IUndoableOperation operation) {
            this.commandManager.execute(operation);
        }

        @Override
        public IRuntime getRuntime() {
            return this.part.getServer().getRuntime();
        }

        @Override
        public void executeLongRunning(Job j) {
            j.schedule();
        }

        @Override
        public void setErrorMessage(String msg) {
            if (this.section != null) {
                this.section.setErrorMessage(msg);
            } else {
                this.part.setErrorMessage(msg);
            }
        }

        @Override
        public Object getAttribute(String key) {
            return null;
        }

        @Override
        public int getCallbackType() {
            return 2;
        }

        @Override
        public void setComplete(boolean complete) {
        }

        public ServerResourceCommandManager getCommandManager() {
            return this.commandManager;
        }

        public ServerEditorPart getPart() {
            return this.part;
        }

        public ServerEditorSection getSection() {
            return this.section;
        }

        public IEditorInput getInput() {
            return this.input;
        }
    }
}

