/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.model;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.BatchProjectChangeEvent;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.core.IBatchProjectChangeListener;
import org.jboss.tools.batch.internal.core.validation.BatchValidator;
import org.jboss.tools.batch.ui.editor.internal.model.BatchletOrChunk;
import org.jboss.tools.batch.ui.editor.internal.model.Chunk;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.editor.internal.util.ModelToBatchArtifactsMapping;

public class RefValidationService
extends ValidationService {
    private Property property;
    private Listener listener;
    private IBatchProject batchProject;
    BatchArtifactType type = null;
    boolean isChunkListener = false;

    protected void initValidationService() {
        Class cls;
        List<BatchArtifactType> types;
        this.property = (Property)this.context(Property.class);
        IProject project = (IProject)((Job)this.context(Job.class)).adapt(IProject.class);
        this.batchProject = BatchCorePlugin.getBatchProject((IProject)project, (boolean)true);
        this.listener = new Listener(){

            public void handle(Event event) {
                RefValidationService.this.refresh();
            }
        };
        this.attach(this.listener);
        if (this.batchProject != null) {
            Listeners.getListener(this.batchProject).add(this);
        }
        if ((types = ModelToBatchArtifactsMapping.getBatchArtifactTypes(cls = this.property.element().type().getModelElementClass())).size() == 1) {
            this.type = types.get(0);
        } else if (types.size() > 1) {
            this.type = BatchArtifactType.STEP_LISTENER;
            Step e = (Step)this.property.element().parent().element();
            ElementList<BatchletOrChunk> ch = e.getBatchletOrChunk();
            if (ch.isEmpty() || ch.get(0) instanceof Chunk) {
                this.isChunkListener = true;
            }
        }
    }

    protected Status compute() {
        Object c;
        if (this.batchProject == null) {
            return Status.createOkStatus();
        }
        String message = null;
        if (this.property instanceof Value && (c = ((Value)this.property).content()) != null) {
            String ref = c.toString();
            Collection as = this.batchProject.getArtifacts(ref);
            if (as.isEmpty()) {
                message = this.type == null ? "" : BatchValidator.TypeToValidationMessage.getNotFoundMessage((BatchArtifactType)this.type);
                message = MessageFormat.format(message, ref);
            } else if (this.type != null) {
                IBatchArtifact a = (IBatchArtifact)as.iterator().next();
                if (this.isChunkListener) {
                    if (!this.type.getTag().equals(a.getArtifactType().getTag())) {
                        message = BatchValidator.TypeToValidationMessage.getWrongTypeMessage((BatchArtifactType)this.type);
                        message = MessageFormat.format(message, ref);
                    }
                } else if (!this.type.equals((Object)a.getArtifactType())) {
                    message = BatchValidator.TypeToValidationMessage.getWrongTypeMessage((BatchArtifactType)this.type);
                }
            }
        }
        return message == null ? Status.createOkStatus() : Status.createErrorStatus(message);
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.detach(this.listener);
        }
        if (this.batchProject != null) {
            Listeners.getListener(this.batchProject).remove(this);
        }
    }

    static class BatchChangeListener
    implements IBatchProjectChangeListener {
        Set<RefValidationService> refs = new HashSet<RefValidationService>();

        BatchChangeListener() {
        }

        synchronized void add(RefValidationService ref) {
            this.refs.add(ref);
        }

        synchronized void remove(RefValidationService ref) {
            this.refs.remove((Object)ref);
        }

        synchronized RefValidationService[] getRefs() {
            return this.refs.toArray(new RefValidationService[this.refs.size()]);
        }

        public void projectChanged(BatchProjectChangeEvent event) {
            RefValidationService[] refValidationServiceArray = this.getRefs();
            int n = refValidationServiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RefValidationService ref = refValidationServiceArray[n2];
                ref.refresh();
                ++n2;
            }
        }
    }

    static class Listeners {
        static Map<String, BatchChangeListener> listeners = new HashMap<String, BatchChangeListener>();

        Listeners() {
        }

        static synchronized BatchChangeListener getListener(IBatchProject batchProject) {
            String name = batchProject.getProject().getName();
            BatchChangeListener listener = listeners.get(name);
            if (listener == null) {
                listener = new BatchChangeListener();
                listeners.put(name, listener);
                batchProject.addBatchProjectListener((IBatchProjectChangeListener)listener);
            }
            return listener;
        }
    }
}

