/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.hyperlink;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PatternFilter;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.ui.JobImages;
import org.jboss.tools.batch.ui.hyperlink.BatchHyperlinkMessages;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.text.ext.hyperlink.xpl.AbstractBaseHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.jst.web.kb.KbQuery;

public class BatchPropertyDialog
extends PopupDialog {
    private IBatchProperty batchProperty;
    private HashMap<IFile, List<BatchUtil.NodePathTextSourceReference>> references = new HashMap();
    private Composite composite;
    private Text fFilterText;
    private TreeViewer tree;
    private ReferencePatternFilter patternFilter;
    static Color gray = new Color(null, 128, 128, 128);
    static Color black = Display.getDefault().getSystemColor(28);
    static StyledString.Styler FILE_NAME_STYLER = new DefaultStyler(black, true, false);
    static StyledString.Styler PATH_STYLER = new DefaultStyler(gray, true, false);
    static StyledString.Styler PROPERTY_PATH_STYLER = new DefaultStyler(black, false, false);

    public BatchPropertyDialog(Shell parentShell, final IBatchProperty batchProperty) {
        super(parentShell, 0, true, true, false, false, false, "", null);
        this.batchProperty = batchProperty;
        BusyIndicator.showWhile((Display)(parentShell != null ? parentShell.getDisplay() : Display.getDefault()), (Runnable)new Runnable(){

            @Override
            public void run() {
                for (IFile file : batchProperty.getArtifact().getProject().getDeclaredBatchJobs()) {
                    List list = BatchUtil.getNodePathPropertyAttributeReferences((IFile)file, (String)batchProperty.getArtifact().getName(), (String)batchProperty.getPropertyName());
                    if (list.size() <= 0) continue;
                    BatchPropertyDialog.this.references.put(file, list);
                }
            }
        });
    }

    public HashMap<IFile, List<BatchUtil.NodePathTextSourceReference>> getDisplayedReferences() {
        return this.references;
    }

    private String computeTitle() {
        StringBuffer result = new StringBuffer();
        result.append(NLS.bind((String)BatchHyperlinkMessages.SHOWING_REFERENCES_FOR_BATCH_PROPERTY, (Object)this.batchProperty.getPropertyName()));
        return result.toString();
    }

    protected Control getFocusControl() {
        return this.getFilterText();
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        this.fFilterText = this.createFilterText(parent);
        return fViewMenuButtonComposite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(BatchHyperlinkMessages.BATCH_PROPERTY_REFERENCES);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setFont(parent.getFont());
        this.setTitleText(this.computeTitle());
        this.createTreeView(this.composite);
        this.composite.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                BatchPropertyDialog.this.close();
            }
        });
        this.installFilter();
        return this.composite;
    }

    void createTreeView(Composite parent) {
        this.tree = new TreeViewer(parent, 2820);
        this.tree.setAutoExpandLevel(-1);
        GridData g = new GridData(1808);
        this.tree.getControl().setLayoutData((Object)g);
        this.tree.setContentProvider((IContentProvider)new TreeContent());
        this.tree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tree.setInput((Object)this.batchProperty);
        this.patternFilter = new ReferencePatternFilter();
        this.tree.setFilters(new ViewerFilter[]{this.patternFilter});
        this.tree.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object o;
                ISelection s = event.getSelection();
                if (!s.isEmpty() && s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof BatchUtil.NodePathTextSourceReference) {
                    BatchPropertyDialog.this.openElement((BatchUtil.NodePathTextSourceReference)o);
                    BatchPropertyDialog.this.close();
                }
            }
        });
        this.tree.getTree().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Widget w;
                ViewerCell cell = BatchPropertyDialog.this.tree.getCell(new Point(e.x, e.y));
                if (cell != null && (w = cell.getItem()) != null && w.getData() != null) {
                    BatchPropertyDialog.this.tree.setSelection((ISelection)new StructuredSelection(w.getData()));
                }
            }
        });
        this.tree.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BatchPropertyDialog.this.gotoSelectedElement();
            }
        });
        this.tree.refresh();
    }

    protected void gotoSelectedElement() {
        Object o;
        ISelection s = this.tree.getSelection();
        if (!s.isEmpty() && s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof BatchUtil.NodePathTextSourceReference) {
            this.openElement((BatchUtil.NodePathTextSourceReference)o);
            this.close();
        }
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.fFilterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    BatchPropertyDialog.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    BatchPropertyDialog.this.tree.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    BatchPropertyDialog.this.tree.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    BatchPropertyDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.fFilterText;
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BatchPropertyDialog.this.patternFilter.setPattern(BatchPropertyDialog.this.fFilterText.getText());
                BatchPropertyDialog.this.tree.refresh();
                BatchPropertyDialog.this.tree.expandAll();
            }
        });
    }

    protected Point getDefaultSize() {
        return new Point(700, 300);
    }

    protected Point getDefaultLocation(Point size) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getActiveShell() == null) {
            return super.getDefaultLocation(size);
        }
        Rectangle b = display.getActiveShell().getBounds();
        int x = b.x + (b.width - size.x) / 2;
        int y = b.y + (b.height - size.y) / 2;
        return new Point(x, y);
    }

    private static StyledString getNodePath(BatchUtil.NodePathTextSourceReference element) {
        StyledString ss = new StyledString();
        List tags = (List)element.getNodePath();
        int index = tags.size() - 1;
        while (index >= 0) {
            KbQuery.Tag tag = (KbQuery.Tag)tags.get(index);
            if (!"job".equalsIgnoreCase(tag.getName())) {
                Map attributes = tag.getAttributes();
                String attributeValue = null;
                String attributeName = "id";
                attributeValue = (String)attributes.get(attributeName);
                if (attributeValue == null) {
                    attributeName = "ref";
                    attributeValue = (String)attributes.get(attributeName);
                }
                ss.append("/", PROPERTY_PATH_STYLER);
                ss.append(tag.getName(), PROPERTY_PATH_STYLER);
                if (attributeValue != null) {
                    ss.append("(", PATH_STYLER).append(attributeName, PATH_STYLER).append("=\"", PATH_STYLER).append(attributeValue, PATH_STYLER).append("\")", PATH_STYLER);
                }
            }
            --index;
        }
        return ss;
    }

    private void openElement(BatchUtil.NodePathTextSourceReference reference) {
        AbstractBaseHyperlink.openFileInEditor((IFile)((IFile)reference.getResource()));
        StructuredSelectionHelper.setSelectionAndRevealInActiveEditor((IRegion)new Region(reference.getStartPosition(), reference.getLength()));
    }

    private static class DefaultStyler
    extends StyledString.Styler {
        private Color foreground;
        private boolean bold;
        private boolean italic;

        public DefaultStyler(Color foreground, boolean bold, boolean italic) {
            this.foreground = foreground;
            this.italic = italic;
            this.bold = bold;
        }

        public void applyStyles(TextStyle textStyle) {
            if (this.foreground != null) {
                textStyle.foreground = this.foreground;
            }
            if (this.italic) {
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            if (this.bold) {
                textStyle.font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
        }
    }

    class LabelProvider
    extends StyledCellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    ILabelProvider {
        LabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString styledString = this.getStyledText(element);
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(element));
            super.update(cell);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof IFile) {
                StyledString sb = new StyledString();
                sb.append(((IFile)element).getName(), FILE_NAME_STYLER).append(" - ");
                sb.append(((IFile)element).getParent().getFullPath().toString(), PATH_STYLER);
                return sb;
            }
            if (element instanceof BatchUtil.NodePathTextSourceReference) {
                return BatchPropertyDialog.getNodePath((BatchUtil.NodePathTextSourceReference)element);
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof IFile) {
                return JobImages.getImage("job.png");
            }
            if (element instanceof BatchUtil.NodePathTextSourceReference) {
                return JobImages.getImage("property.png");
            }
            return null;
        }
    }

    class ReferencePatternFilter
    extends PatternFilter {
        ReferencePatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            boolean parentMatch;
            if (element instanceof BatchUtil.NodePathTextSourceReference && (parentMatch = super.isLeafMatch(viewer, (Object)((BatchUtil.NodePathTextSourceReference)element).getResource()))) {
                return true;
            }
            return super.isLeafMatch(viewer, element);
        }
    }

    class TreeContent
    implements ITreeContentProvider {
        TreeContent() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IBatchProperty) {
                return BatchPropertyDialog.this.references.keySet().toArray();
            }
            if (parentElement instanceof IFile) {
                return ((List)BatchPropertyDialog.this.references.get((IFile)parentElement)).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof BatchUtil.NodePathTextSourceReference) {
                return ((ITextSourceReference)element).getResource();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IBatchProperty) {
                return BatchPropertyDialog.this.references.keySet().size() > 0;
            }
            if (element instanceof IFile) {
                return ((List)BatchPropertyDialog.this.references.get((IFile)element)).size() > 0;
            }
            return false;
        }
    }
}

