/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.eclipse.dialog;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.eclipse.Messages;

public class BrowserSimErrorDialog
extends MessageDialog {
    private static final String BROWSERSIM_PREFERENCE_PAGE_ID = "org.jboss.tools.browsersim.eclipse.preferences.BrowserSimPreferences";
    private String programName;

    public BrowserSimErrorDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String programName, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, MessageFormat.format(Messages.BrowserSimErrorDialog_ERROR_MESSAGE_HEADER, programName), dialogImageType, dialogButtonLabels, defaultIndex);
        this.programName = programName;
    }

    protected Control createCustomArea(Composite parent) {
        Link link = new Link(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        link.setData((Object)data);
        boolean is32bitEclipse = "x86".equals(PlatformUtil.getArch());
        IPreferenceNode jreNode = this.getPreferenceNode(BROWSERSIM_PREFERENCE_PAGE_ID);
        String bit = is32bitEclipse ? "32-bit" : "64-bit";
        String message = MessageFormat.format(Messages.BrowserSimErrorDialog_ERROR_MESSAGE_COMMON, this.programName, jreNode.getLabelText(), bit);
        link.setText(message);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserSimErrorDialog.this.close();
                PreferencesUtil.createPreferenceDialogOn(null, (String)BrowserSimErrorDialog.BROWSERSIM_PREFERENCE_PAGE_ID, (String[])new String[]{BrowserSimErrorDialog.BROWSERSIM_PREFERENCE_PAGE_ID}, null).open();
            }
        });
        return link;
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        for (IPreferenceNode next : PlatformUI.getWorkbench().getPreferenceManager().getElements(0)) {
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }
}

