/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.ui.CustomMessageBox;
import org.jboss.tools.browsersim.ui.Messages;

public class MessageBoxWithLinks
extends CustomMessageBox {
    private String message;
    private String header;

    public MessageBoxWithLinks(Shell parent, String message, Image icon, String header) {
        super(parent, icon);
        this.message = message;
        this.header = header;
    }

    @Override
    protected void createWidgets() {
        super.createWidgets();
        Link link = new Link(this.getMessageComposite(), 64);
        link.setText(this.message);
        link.setBackground(this.getMessageCompositeBackground());
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)event.text);
            }
        });
        this.addButtons();
        this.getShell().setText(this.header);
        this.getShell().pack();
    }

    protected void addButtons() {
        Button ok = new Button(this.getButtonsComposite(), 8);
        ok.setText(Messages.ExceptionNotifier_OK);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBoxWithLinks.this.getShell().close();
            }
        });
        GridData okLayoutData = new GridData(0x1000008, 0x1000000, true, true);
        okLayoutData.widthHint = 88;
        ok.setLayoutData((Object)okLayoutData);
        this.getShell().setDefaultButton(ok);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

