/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.skin;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.ui.SizeWarningDialog;
import org.jboss.tools.browsersim.ui.model.TruncateWindow;
import org.jboss.tools.browsersim.ui.model.preferences.CommonPreferences;
import org.jboss.tools.browsersim.ui.model.preferences.SpecificPreferences;
import org.jboss.tools.browsersim.ui.skin.ResizableSkinSizeAdvisor;
import org.jboss.tools.browsersim.ui.util.BrowserSimUtil;

public class ResizableSkinSizeAdvisorImpl
implements ResizableSkinSizeAdvisor {
    private CommonPreferences commonPreferences;
    private SpecificPreferences specificPreferences;
    private Shell shell;

    public ResizableSkinSizeAdvisorImpl(CommonPreferences cp, SpecificPreferences sp, Shell shell) {
        this.commonPreferences = cp;
        this.specificPreferences = sp;
        this.shell = shell;
    }

    @Override
    public Point checkWindowSize(int orientation, Point prefferedSize, Point prefferedShellSize) {
        Rectangle clientArea = BrowserSimUtil.getMonitorClientArea(this.shell);
        TruncateWindow truncateWindow = null;
        if (this.commonPreferences.getTruncateWindow() == TruncateWindow.PROMPT) {
            if (prefferedShellSize.x > clientArea.width || prefferedShellSize.y > clientArea.height) {
                String deviceName = this.commonPreferences.getDevices().get(this.specificPreferences.getSelectedDeviceId()).getName();
                SizeWarningDialog dialog = new SizeWarningDialog(this.shell, new Point(clientArea.width, clientArea.height), prefferedShellSize, deviceName, orientation == 0 || orientation == 180);
                dialog.open();
                truncateWindow = dialog.getTruncateWindow();
                if (dialog.getRememberDecision()) {
                    this.commonPreferences.setTruncateWindow(truncateWindow);
                }
            }
        } else {
            truncateWindow = this.commonPreferences.getTruncateWindow();
        }
        Point size = new Point(prefferedShellSize.x, prefferedShellSize.y);
        if (TruncateWindow.ALWAYS_TRUNCATE.equals((Object)truncateWindow)) {
            size.x = Math.min(prefferedShellSize.x, clientArea.width);
            size.y = Math.min(prefferedShellSize.y, clientArea.height);
        }
        return size;
    }
}

