/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.tools.browsersim.ui.BrowserSim;
import org.jboss.tools.browsersim.ui.BrowserSimLogger;
import org.jboss.tools.browsersim.ui.util.PreferencesUtil;

public class ManifestUtil {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String REQUIRE_BUNDLE_VERSION = "bundle-version";
    private static final String JETTY = "jetty";

    public static String getManifestVersion(Class<?> clazz) {
        String manifestVersion = ManifestUtil.getManifestVersion(ManifestUtil.getManifestFromJar(clazz));
        if (!PreferencesUtil.isNullOrEmpty(manifestVersion)) {
            return manifestVersion;
        }
        return ManifestUtil.getManifestVersion(ManifestUtil.getManifestFromFile(clazz));
    }

    public static Manifest getManifest(Class<?> clazz) {
        Manifest fromJar = ManifestUtil.getManifestFromJar(clazz);
        return fromJar != null ? fromJar : ManifestUtil.getManifestFromFile(clazz);
    }

    @Deprecated
    public static String getJettyVersion() {
        String[] requiredBundles;
        Manifest manifest = ManifestUtil.getManifest(BrowserSim.class);
        String requireBundle = manifest.getMainAttributes().getValue(REQUIRE_BUNDLE);
        String[] stringArray = requiredBundles = requireBundle.split(",");
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            if (bundle.contains(JETTY)) {
                String[] jettyBundle;
                String[] stringArray2 = jettyBundle = bundle.split(";");
                int n3 = jettyBundle.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jettyBundlePart = stringArray2[n4];
                    if (jettyBundlePart.startsWith(REQUIRE_BUNDLE_VERSION)) {
                        return jettyBundlePart.substring(REQUIRE_BUNDLE_VERSION.length() + 2, jettyBundlePart.length() - 1);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private static String getManifestVersion(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        String bundleId = mainAttributes.getValue(BUNDLE_SYMBOLIC_NAME);
        if (bundleId != null && bundleId.startsWith("org.jboss.tools.browsersim.ui")) {
            return mainAttributes.getValue(BUNDLE_VERSION);
        }
        return null;
    }

    private static Manifest getManifestFromJar(Class<?> clazz) {
        try {
            Enumeration<URL> manifestUrls = clazz.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifestUrls.hasMoreElements()) {
                URL manifestUrl = manifestUrls.nextElement();
                InputStream inputStream = manifestUrl.openStream();
                if (inputStream == null) continue;
                return new Manifest(inputStream);
            }
        }
        catch (IOException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        return null;
    }

    private static Manifest getManifestFromFile(Class<?> clazz) {
        try {
            URL browserSimBaseUrl = BrowserSim.class.getClassLoader().getResource(".");
            if (browserSimBaseUrl != null && "file".equals(browserSimBaseUrl.getProtocol())) {
                File binDir = new File(browserSimBaseUrl.getFile());
                File browsersimDir = binDir.getParentFile();
                File manifestFile = new File(browsersimDir, "META-INF/MANIFEST.MF");
                FileInputStream inputStream = new FileInputStream(manifestFile);
                return new Manifest(inputStream);
            }
        }
        catch (IOException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        return null;
    }
}

