/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.xml.beans.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.NamespaceMapping;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CDINamespaces {
    private static Map<String, CDINamespaces> map = new HashMap<String, CDINamespaces>();
    String versionSuffix = null;
    private Map<String, String> namespaceToURI = new HashMap<String, String>();
    private Map<String, String> uriToNamespace = new HashMap<String, String>();
    private Map<String, String> namespaceToSchema = new HashMap<String, String>();
    static String XMLNS_PREFIX = "xmlns:";

    public static CDINamespaces getInstance(XModelMetaData meta, String version) {
        CDINamespaces instance = map.get(version);
        if (instance == null) {
            instance = new CDINamespaces(meta, version);
        }
        return instance;
    }

    private CDINamespaces(XModelMetaData meta, String versionSuffix) {
        String v;
        XMapping m = meta.getMapping("CDINamespaces");
        if (m == null) {
            return;
        }
        this.versionSuffix = versionSuffix;
        String[] keys = m.getKeys();
        int i = 0;
        while (i < keys.length) {
            v = m.getValue(keys[i]);
            this.namespaceToURI.put(keys[i], v);
            this.uriToNamespace.put(v, keys[i]);
            ++i;
        }
        m = meta.getMapping("CDISchemas");
        if (m == null) {
            return;
        }
        keys = m.getKeys();
        i = 0;
        while (i < keys.length) {
            if (keys[i].endsWith(versionSuffix)) {
                v = m.getValue(keys[i]);
                String key = keys[i].substring(0, keys[i].length() - versionSuffix.length());
                this.namespaceToSchema.put(key, v);
            }
            ++i;
        }
    }

    public NamespaceMapping getNamespaceMapping(Element element) {
        NamespaceMapping mapping = new NamespaceMapping();
        NamedNodeMap as = element.getAttributes();
        int i = 0;
        while (i < as.getLength()) {
            Node n = as.item(i);
            String name = n.getNodeName();
            if (name.startsWith(XMLNS_PREFIX)) {
                String actualNamespace = name.substring(XMLNS_PREFIX.length());
                String uri = n.getNodeValue();
                String defaultNamespace = this.getDefaultNamespace(uri);
                if (defaultNamespace == null) {
                    defaultNamespace = name.substring(XMLNS_PREFIX.length());
                }
                if (defaultNamespace != null) {
                    mapping.addNamespace(defaultNamespace, actualNamespace, uri);
                }
            }
            ++i;
        }
        return mapping;
    }

    public String getDefaultNamespace(String uri) {
        return this.uriToNamespace.get(uri);
    }

    public String getURI(String namespace) {
        return this.namespaceToURI.get(namespace);
    }

    public String getSchema(String namespace) {
        return this.namespaceToSchema.get(namespace);
    }

    public void validateNamespaces(XModelObject object, Element element) {
        NamespaceMapping namespaceMapping = NamespaceMapping.load((XModelObject)object);
        if (namespaceMapping == null) {
            namespaceMapping = new NamespaceMapping();
        }
        StringBuffer loc = new StringBuffer();
        loc.append(object.getAttributeValue("xsi:schemaLocation"));
        this.doValidateNamespaces(object, element, namespaceMapping, loc);
        object.setAttributeValue("xsi:schemaLocation", loc.toString());
    }

    void doValidateNamespaces(XModelObject object, Element element, NamespaceMapping namespaceMapping, StringBuffer loc) {
        XModelObject[] cs = object.getChildren();
        HashSet<String> ns = new HashSet<String>();
        int i = 0;
        while (i < cs.length) {
            String defaultNamespace;
            String n = null;
            if (cs[i].getModelEntity().getName().equals(XModelObjectLoaderUtil.ENT_ANY_ELEMENT)) {
                n = cs[i].getAttributeValue("tag");
                this.doValidateNamespaces(cs[i], element, namespaceMapping, loc);
            } else {
                n = cs[i].getModelEntity().getXMLSubPath();
            }
            int k = n.indexOf(58);
            if (k >= 0 && !ns.contains(defaultNamespace = n.substring(0, k))) {
                ns.add(defaultNamespace);
                String uri = this.getURI(defaultNamespace);
                if (uri == null) {
                    uri = namespaceMapping.getURIForDefaultNamespace(defaultNamespace);
                }
                if (uri != null) {
                    String actualNamespace = namespaceMapping.getActualNamespace(defaultNamespace);
                    if (actualNamespace == null) {
                        actualNamespace = defaultNamespace;
                    }
                    element.setAttribute(String.valueOf(XMLNS_PREFIX) + actualNamespace, uri);
                    String schema = this.getSchema(defaultNamespace);
                    if (loc.indexOf(uri) < 0 && schema != null) {
                        loc.append(' ').append(uri).append(' ').append(schema);
                    }
                }
            }
            ++i;
        }
    }
}

