/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.ui.Messages;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;

public class JBossConnectTab
extends AbstractLaunchConfigurationTab {
    private Group messageGroup;
    private Button jbossConfigurationButton;
    private Image image = RemoteDebugUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.common.jdt.debug.ui", (String)"/icons/jboss.gif").createImage();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)1808);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        this.createVerticalSpacer(comp, 2);
        this.jbossConfigurationButton = this.createCheckButton(comp, "JBoss Remote Configuration");
        this.jbossConfigurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBossConnectTab.this.setDirty(true);
                JBossConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 2);
        this.messageGroup = new Group(comp, 0);
        this.messageGroup.setText(Messages.JavaConnectTab_Warning);
        this.messageGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(4, 4, true, false);
        this.messageGroup.setLayoutData((Object)gd);
        Label noteLabel = new Label((Composite)this.messageGroup, 0);
        gd = new GridData(1, 1, false, false);
        noteLabel.setLayoutData((Object)gd);
        Image image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        image.setBackground(noteLabel.getBackground());
        noteLabel.setImage(image);
        Text noteText = new Text((Composite)this.messageGroup, 72);
        gd = new GridData(4, 4, true, false);
        GC gc = new GC((Drawable)parent);
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)3);
        gc.dispose();
        noteText.setLayoutData((Object)gd);
        noteText.setText(Messages.JavaConnectTab_JDK_Required);
        this.messageGroup.setVisible(!RemoteDebugActivator.getDefault().isJdk());
        Button addJDK = new Button((Composite)this.messageGroup, 8);
        addJDK.setText(Messages.JavaConnectTab_Add_JDK);
        gd = new GridData(1, 0x1000000, false, false);
        addJDK.setLayoutData((Object)gd);
        addJDK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String preferenceId = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)JBossConnectTab.this.getShell(), (String)preferenceId, null, null);
                dialog.open();
                JBossConnectTab.this.updateLaunchConfigurationDialog();
                JBossConnectTab.this.messageGroup.setVisible(!RemoteDebugActivator.getDefault().isJdk());
            }
        });
        this.setControl((Control)comp);
    }

    private void updateMarkAsJBossFromConfig(ILaunchConfiguration config) {
        boolean markAsJBoss = false;
        try {
            markAsJBoss = config.getAttribute("JBossRemoteJavaApplication", false);
        }
        catch (CoreException ce) {
            RemoteDebugUIActivator.log(ce);
        }
        this.jbossConfigurationButton.setSelection(markAsJBoss);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("JBossRemoteJavaApplication", this.jbossConfigurationButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("JBossRemoteJavaApplication", false);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public String getName() {
        return "JBoss Preferences";
    }

    public String getId() {
        return "org.jboss.tools.common.jdt.debug.ui.launching.launchConfigurationTabGroup.JBossRemoteJavaApplication2";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateMarkAsJBossFromConfig(configuration);
    }

    public Image getImage() {
        return this.image;
    }

    public void dispose() {
        this.image.dispose();
        super.dispose();
    }
}

