/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.preferences;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.jdt.debug.ui.preferences.RemoteDebug;

public class RemoteDebugEditingSupport
extends EditingSupport {
    private CellEditor editor;
    private int column;

    public RemoteDebugEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        switch (column) {
            case 1: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 2: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 3: {
                this.editor = new CheckboxCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            default: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
            }
        }
        this.column = column;
    }

    protected boolean canEdit(Object element) {
        return this.column != 0;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        RemoteDebug remoteDebug = (RemoteDebug)element;
        String value = null;
        switch (this.column) {
            case 0: {
                value = remoteDebug.getKey(true);
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 1: {
                value = remoteDebug.getDescription();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 2: {
                value = remoteDebug.getPort();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 3: {
                boolean show = remoteDebug.isShow();
                return show;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        RemoteDebug remoteDebug = (RemoteDebug)element;
        switch (this.column) {
            case 1: {
                if (value != null) {
                    remoteDebug.setDescription(value.toString());
                } else {
                    remoteDebug.setDescription(null);
                }
                ISelection selection = this.getViewer().getSelection();
                this.getViewer().setSelection(null);
                this.getViewer().setSelection(selection);
                break;
            }
            case 2: {
                if (value != null) {
                    remoteDebug.setPort(value.toString());
                } else {
                    remoteDebug.setPort(null);
                }
                ISelection selection = this.getViewer().getSelection();
                this.getViewer().setSelection(null);
                this.getViewer().setSelection(selection);
                break;
            }
            case 3: {
                remoteDebug.setShow((Boolean)value);
                break;
            }
        }
        this.getViewer().update(element, null);
    }
}

