/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VmModel {
    private String pid;
    private String port;
    private String transport;
    private String jvmArgs;
    private String mainClass;
    private String mainArgs;
    private Map<String, String> args;
    private String jdwpArgs;
    private String displayName;

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
        this.args = this.getArguments(jvmArgs);
        this.jdwpArgs = this.getJdwpArg(this.args);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainArgs() {
        return this.mainArgs;
    }

    public void setMainArgs(String mainArgs) {
        this.mainArgs = mainArgs;
    }

    private Map<String, String> getArguments(String args) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String[] stringArray = args.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            if (argument.length() != 0) {
                String[] nameValue = argument.split("=", 2);
                if (nameValue.length == 1) {
                    arguments.put(nameValue[0], nameValue[0]);
                } else {
                    arguments.put(nameValue[0], nameValue[1]);
                }
            }
            ++n2;
        }
        return arguments;
    }

    private String getJdwpArg(Map<String, String> arguments) {
        String jdwpArg = arguments.get("-agentlib:jdwp");
        if (jdwpArg == null) {
            Iterator<String> it = arguments.keySet().iterator();
            String iNext = null;
            while (it.hasNext()) {
                String[] keySegments;
                iNext = it.next();
                if (!iNext.startsWith("-Xrunjdwp:") || (keySegments = iNext.split(":")).length <= 1) continue;
                String ret = String.valueOf(keySegments[1]) + "=" + arguments.get(iNext);
                return ret;
            }
        }
        return jdwpArg;
    }

    @Deprecated
    public String getPort() {
        return this.getDebugPort();
    }

    public String getDebugPort() {
        if (this.port != null) {
            return this.port;
        }
        if (this.jdwpArgs == null) {
            return null;
        }
        String[] stringArray = this.jdwpArgs.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String address;
            String argument = stringArray[n2];
            String[] nameValue = argument.split("=", 2);
            if (nameValue.length == 2 && "address".equals(nameValue[0]) && (address = nameValue[1]) != null) {
                String[] addresses = address.split(":", 2);
                if (addresses.length == 1) {
                    this.port = addresses[0];
                    return this.port;
                }
                this.port = addresses[1];
                return this.port;
            }
            ++n2;
        }
        return null;
    }

    public String getTransport() {
        if (this.transport != null) {
            return this.transport;
        }
        if (this.jdwpArgs == null) {
            return null;
        }
        String[] stringArray = this.jdwpArgs.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            String[] nameValue = argument.split("=", 2);
            if (nameValue.length == 2 && "transport".equals(nameValue[0])) {
                this.transport = nameValue[1];
                return this.transport;
            }
            if (nameValue.length == 1 && "dt_socket".equals(nameValue[0])) {
                this.transport = nameValue[0];
                return this.transport;
            }
            ++n2;
        }
        return null;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            StringBuffer buffer = new StringBuffer();
            if (this.getMainClass() != null) {
                String port;
                buffer.append(this.mainClass);
                if (this.pid != null) {
                    if (buffer.length() > 0) {
                        buffer.append(",pid=");
                    }
                    buffer.append(this.pid);
                }
                if ((port = this.getPort()) != null) {
                    if (buffer.length() > 0) {
                        buffer.append(",port=");
                    }
                    buffer.append(port);
                }
            }
            if (buffer.length() > 0) {
                this.displayName = buffer.toString();
            }
        }
        return this.displayName;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Deprecated
    public void setPort(String port) {
        this.setDebugPort(port);
    }

    public void setDebugPort(String port) {
        this.port = port;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String toString() {
        return "VmModel [pid=" + this.pid + ", port=" + this.port + ", transport=" + this.transport + ", jvmArgs=" + this.jvmArgs + ", mainClass=" + this.mainClass + ", mainArgs=" + this.mainArgs + ", args=" + this.args + ", jdwpArgs=" + this.jdwpArgs + ", displayName=" + this.displayName + "]";
    }
}

