/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jboss.tools.common.jdt.debug.VmModel;

public class VmModelCache {
    private static VmModelCache instance = new VmModelCache();
    private HashMap<String, List<VmModel>> models = new HashMap();

    public static VmModelCache getDefault() {
        return instance;
    }

    public synchronized List<VmModel> getModels(String hostName) {
        return this.models.get(hostName);
    }

    public synchronized void cacheModels(String host, List<VmModel> models) {
        this.models.put(host, models);
    }

    public synchronized VmModel getModel(String hostName, int pid) {
        List<VmModel> list = this.models.get(hostName);
        if (list == null) {
            return null;
        }
        for (VmModel m : list) {
            if (!m.getPid().equals(Integer.toString(pid))) continue;
            return m;
        }
        return null;
    }

    public synchronized void cacheModel(String hostName, int pid, VmModel m) {
        List<VmModel> list = this.models.get(hostName);
        if (list == null) {
            list = new ArrayList<VmModel>();
            this.models.put(hostName, list);
        }
        Iterator<VmModel> i = list.iterator();
        while (i.hasNext()) {
            VmModel mo = i.next();
            if (mo == null || mo.getPid() == null || !mo.getPid().equals(Integer.toString(pid))) continue;
            i.remove();
        }
        list.add(m);
    }
}

