/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.sourcelookup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;

public class DebugLaunchConfigurationListener
implements ILaunchConfigurationListener {
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    private void updateLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            if (!RemoteDebugActivator.REMOTE_JAVA_APPLICATION_ID.equals(configuration.getType().getIdentifier())) {
                return;
            }
            if (configuration.getAttributes().containsKey(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER)) {
                return;
            }
            if (!configuration.getAttribute("JBossRemoteJavaApplication", false)) {
                return;
            }
            IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            if (javaProject == null) {
                return;
            }
            String sourcePathComputer = configuration.getAttribute(ISourcePathComputer.ATTR_SOURCE_PATH_COMPUTER_ID, null);
            ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy(configuration);
            boolean save = false;
            if (sourcePathComputer == null) {
                wc.setAttribute(ISourcePathComputer.ATTR_SOURCE_PATH_COMPUTER_ID, "org.jboss.tools.common.jdt.debug.sourceLookup.remoteDebugSourcePathComputer");
                save = true;
            }
            if (javaProject.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                if (RemoteDebugActivator.m2eExists()) {
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.m2e.launchconfig.classpathProvider");
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.m2e.launchconfig.sourcepathProvider");
                } else {
                    String sourcePathProvider;
                    String classPathProvider = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "");
                    if ("org.eclipse.m2e.launchconfig.classpathProvider".equals(classPathProvider)) {
                        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
                    }
                    if ("org.eclipse.m2e.launchconfig.sourcepathProvider".equals(sourcePathProvider = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, ""))) {
                        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
                    }
                }
                save = true;
            }
            if (save) {
                wc.doSave();
            }
        }
        catch (CoreException e) {
            RemoteDebugActivator.pluginLog().logError((Throwable)e);
        }
    }

    private ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy(ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = configuration instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        return wc;
    }
}

