/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.sourcelookup;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;

public class RemoteDebugSourcePathComputer
implements ISourcePathComputerDelegate {
    public static final String ID = "org.jboss.tools.common.jdt.debug.sourceLookup.remoteDebugSourcePathComputer";
    public static final String JDT_JAVA_APPLICATION = "org.eclipse.jdt.launching.localJavaApplication";
    public static final String JDT_JUNIT_TEST = "org.eclipse.jdt.junit.launchconfig";

    public String getId() {
        return ID;
    }

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration);
        List projectNames = configuration.getAttribute("selectedProjects", new ArrayList());
        for (String projectName : projectNames) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) continue;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            entries = this.addProjectEntry(entries, javaProject);
        }
        IRuntimeClasspathEntry[] resolved = RemoteDebugActivator.m2eExists() ? this.resolveM2eSourceLookupPath(configuration, entries) : JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        return JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
    }

    private IRuntimeClasspathEntry[] resolveM2eSourceLookupPath(ILaunchConfiguration configuration, IRuntimeClasspathEntry[] entries) throws CoreException {
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        IRuntimeClasspathEntry[] runtimeResolved = this.getResolvedEntries(entries, projectName, JDT_JAVA_APPLICATION);
        IRuntimeClasspathEntry[] testResolved = this.getResolvedEntries(entries, projectName, JDT_JUNIT_TEST);
        return this.combineEntries(runtimeResolved, testResolved);
    }

    private IRuntimeClasspathEntry[] combineEntries(IRuntimeClasspathEntry[] runtimeResolved, IRuntimeClasspathEntry[] testResolved) {
        IRuntimeClasspathEntry entry;
        LinkedHashSet<IRuntimeClasspathEntry> resolved = new LinkedHashSet<IRuntimeClasspathEntry>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = runtimeResolved;
        int n = runtimeResolved.length;
        int n2 = 0;
        while (n2 < n) {
            entry = iRuntimeClasspathEntryArray[n2];
            resolved.add(entry);
            ++n2;
        }
        iRuntimeClasspathEntryArray = testResolved;
        n = testResolved.length;
        n2 = 0;
        while (n2 < n) {
            entry = iRuntimeClasspathEntryArray[n2];
            resolved.add(entry);
            ++n2;
        }
        return resolved.toArray(new IRuntimeClasspathEntry[0]);
    }

    private IRuntimeClasspathEntry[] getResolvedEntries(IRuntimeClasspathEntry[] entries, String projectName, String typeId) throws CoreException {
        ILaunchConfiguration tempConfiguration = RemoteDebugActivator.createTemporaryLaunchConfiguration(projectName, typeId);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)tempConfiguration);
        tempConfiguration.delete();
        return resolved;
    }

    private IRuntimeClasspathEntry[] addProjectEntry(IRuntimeClasspathEntry[] entries, IJavaProject javaProject) {
        if (javaProject != null) {
            IRuntimeClasspathEntry runtime = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)javaProject);
            IRuntimeClasspathEntry[] copy = new IRuntimeClasspathEntry[entries.length + 1];
            System.arraycopy(entries, 0, copy, 0, entries.length);
            copy[entries.length] = runtime;
            entries = copy;
        }
        return entries;
    }
}

