/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.jboss.tools.common.text.ITextProposalProvider;
import org.jboss.tools.common.text.TextProposal;

public class ProposalSorter {
    public static List<ICompletionProposal> filterAndSortProposals(List<ICompletionProposal> proposals, IProgressMonitor monitor, CompletionProposalInvocationContext context, IProposalFilter filter) {
        if (proposals == null) {
            return null;
        }
        Object[] resultArray = proposals.toArray(new ICompletionProposal[proposals.size()]);
        resultArray = ProposalSorter.makeUnique((ICompletionProposal[])resultArray);
        resultArray = ProposalSorter.filterProposals((ICompletionProposal[])resultArray, context, filter);
        Object[] sorted = ProposalSorter.createSorter().sort(resultArray);
        System.arraycopy(sorted, 0, resultArray, 0, sorted.length);
        return Arrays.asList(resultArray);
    }

    public static List<ICompletionProposal> filterAndSortProposals(List<ICompletionProposal> proposals, IProgressMonitor monitor, CompletionProposalInvocationContext context) {
        return ProposalSorter.filterAndSortProposals(proposals, monitor, context, null);
    }

    private static Sorter createSorter() {
        return new Sorter(){

            public boolean compare(Object proposal1, Object proposal2) {
                int pr1 = Integer.MIN_VALUE;
                int pr2 = Integer.MIN_VALUE;
                ICompletionProposal p1 = (ICompletionProposal)proposal1;
                ICompletionProposal p2 = (ICompletionProposal)proposal2;
                if (p1 instanceof IRelevanceCompletionProposal) {
                    pr1 = ((IRelevanceCompletionProposal)p1).getRelevance();
                }
                if (p2 instanceof IRelevanceCompletionProposal) {
                    pr2 = ((IRelevanceCompletionProposal)p2).getRelevance();
                }
                if (pr1 == pr2) {
                    String str2;
                    String str1 = p1.getDisplayString() == null ? "" : p1.getDisplayString();
                    String string = str2 = p2.getDisplayString() == null ? "" : p2.getDisplayString();
                    return str2.compareTo(str1) > 0;
                }
                return pr1 > pr2;
            }
        };
    }

    public static ICompletionProposal[] makeUnique(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return null;
        }
        HashMap<String, ICompletionProposal> existingProposals = new HashMap<String, ICompletionProposal>(proposals.length);
        ArrayList<ICompletionProposal> unique = new ArrayList<ICompletionProposal>(proposals.length);
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (proposal != null) {
                String replString = null;
                String dispString = null;
                if (proposal instanceof CustomCompletionProposal) {
                    replString = ((CustomCompletionProposal)proposal).getReplacementString();
                }
                dispString = ProposalSorter.unQuote(proposal.getDisplayString());
                replString = ProposalSorter.getReplacementWord(replString == null ? dispString : replString);
                boolean isFilterable = true;
                if (proposal instanceof ITextProposalProvider) {
                    TextProposal textProposal = ((ITextProposalProvider)proposal).getTextProposal();
                    boolean bl = isFilterable = textProposal == null || textProposal.isFilterable();
                }
                if (isFilterable) {
                    ICompletionProposal existingProposal = (ICompletionProposal)existingProposals.get(replString);
                    if (existingProposal == null) {
                        existingProposals.put(replString, proposal);
                        unique.add(proposal);
                    } else if (existingProposal instanceof IRelevanceCompletionProposal && proposal instanceof IRelevanceCompletionProposal && ((IRelevanceCompletionProposal)existingProposal).getRelevance() < ((IRelevanceCompletionProposal)proposal).getRelevance()) {
                        existingProposals.put(replString, proposal);
                        unique.remove(existingProposal);
                        unique.add(proposal);
                    }
                } else {
                    unique.add(proposal);
                }
            }
            ++n2;
        }
        return unique.toArray(new ICompletionProposal[unique.size()]);
    }

    public static ICompletionProposal[] filterProposals(ICompletionProposal[] proposals, CompletionProposalInvocationContext context, IProposalFilter filter) {
        if (filter == null) {
            return proposals;
        }
        ArrayList<ICompletionProposal> filtered = new ArrayList<ICompletionProposal>(proposals.length);
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (filter.isValidProposal(context, proposal)) {
                filtered.add(proposal);
            }
            ++n2;
        }
        return filtered.toArray(new ICompletionProposal[filtered.size()]);
    }

    private static String getReplacementWord(String replacement) {
        replacement = replacement == null ? "" : replacement;
        int index = replacement.indexOf(62);
        if (index != -1 && (replacement = replacement.substring(0, index).trim()).endsWith("/")) {
            replacement = replacement.substring(0, replacement.length() - 1).trim();
        }
        if ((index = replacement.indexOf("=")) != -1) {
            replacement = replacement.substring(0, index).trim();
        }
        if ((index = replacement.indexOf(" ")) != -1) {
            replacement = replacement.substring(0, index).trim();
        }
        return replacement;
    }

    private static String unQuote(String str) {
        String string = str = str == null ? "" : str.toLowerCase();
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim().toLowerCase();
        return str;
    }

    public static interface IProposalFilter {
        public boolean isValidProposal(CompletionProposalInvocationContext var1, ICompletionProposal var2);
    }
}

