/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.info;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.DebugInfoHoverProcessor;
import org.jboss.tools.common.text.xml.xpl.MarkerProblemAnnotationHoverProcessor;

public class ChainTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private ITextHover fBestMatchHover;
    private ITextHover[] fTagInfoHovers;
    private List<ITextHover> fTextHovers;

    public ChainTextHover(ITextHover infoTagHover) {
        this(new ITextHover[]{infoTagHover});
    }

    public ChainTextHover(ITextHover[] infoTagHovers) {
        this.fTagInfoHovers = infoTagHovers;
    }

    private List<ITextHover> createTextHoversList() {
        ArrayList<ITextHover> hoverList = new ArrayList<ITextHover>();
        if (Logger.isTracing((String)"debuginfohover")) {
            hoverList.add((ITextHover)new DebugInfoHoverProcessor());
        }
        hoverList.add((ITextHover)new MarkerProblemAnnotationHoverProcessor());
        int lastToolsIndex = hoverList.size();
        int i = 0;
        while (i < this.fTagInfoHovers.length) {
            if (this.fTagInfoHovers[i].getClass().getName().startsWith("org.jboss.tools.")) {
                hoverList.add(lastToolsIndex, this.fTagInfoHovers[i]);
                ++lastToolsIndex;
            } else {
                hoverList.add(this.fTagInfoHovers[i]);
            }
            ++i;
        }
        hoverList.add((ITextHover)new AnnotationHoverProcessor());
        return hoverList;
    }

    public IInformationControlCreator getHoverControlCreator() {
        IInformationControlCreator creator = null;
        if (this.fBestMatchHover instanceof ITextHoverExtension) {
            creator = ((ITextHoverExtension)this.fBestMatchHover).getHoverControlCreator();
        }
        return creator;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        String displayInfo = null;
        if (this.fBestMatchHover != null) {
            displayInfo = this.fBestMatchHover.getHoverInfo(viewer, hoverRegion);
        }
        if (displayInfo == null) {
            Iterator<ITextHover> i = this.getTextHovers().iterator();
            while (i.hasNext() && displayInfo == null) {
                ITextHover hover = i.next();
                if (hover instanceof ITextHoverExtension2) {
                    Object displayInfoObject = ((ITextHoverExtension2)hover).getHoverInfo2(viewer, hoverRegion);
                    if (displayInfoObject == null) continue;
                    displayInfo = displayInfoObject.toString();
                    continue;
                }
                displayInfo = hover.getHoverInfo(viewer, hoverRegion);
            }
        }
        return displayInfo;
    }

    public Object getHoverInfo2(ITextViewer viewer, IRegion hoverRegion) {
        Object objectInfo = null;
        if (this.fBestMatchHover != null) {
            objectInfo = this.fBestMatchHover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)this.fBestMatchHover).getHoverInfo2(viewer, hoverRegion) : this.fBestMatchHover.getHoverInfo(viewer, hoverRegion);
        }
        if (objectInfo == null) {
            Iterator<ITextHover> i = this.getTextHovers().iterator();
            while (i.hasNext() && objectInfo == null) {
                ITextHover hover = i.next();
                objectInfo = hover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)hover).getHoverInfo2(viewer, hoverRegion) : hover.getHoverInfo(viewer, hoverRegion);
            }
        }
        return objectInfo;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        IRegion hoverRegion = null;
        ITextHover hover = null;
        Iterator<ITextHover> i = this.getTextHovers().iterator();
        while (i.hasNext() && hoverRegion == null) {
            hover = i.next();
            hoverRegion = hover.getHoverRegion(viewer, offset);
        }
        this.fBestMatchHover = hoverRegion != null ? hover : null;
        return hoverRegion;
    }

    private List<ITextHover> getTextHovers() {
        if (this.fTextHovers == null) {
            this.fTextHovers = this.createTextHoversList();
        }
        return this.fTextHovers;
    }
}

