/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jboss.tools.common.ui.preferences.SeverityPreferencesMessages;

public abstract class SeverityConfigurationBlock
extends OptionsConfigurationBlock {
    protected static final String ERROR = "error";
    protected static final String WARNING = "warning";
    protected static final String IGNORE = "ignore";
    protected static final String ENABLED = "enabled";
    protected static final String DISABLED = "disabled";
    protected String[] errorWarningIgnore = new String[]{"error", "warning", "ignore"};
    protected String[] enableDisableValues = new String[]{"enabled", "disabled"};
    protected String[] errorWarningIgnoreLabels = new String[]{SeverityPreferencesMessages.VALIDATOR_CONFIGURATION_BLOCK_ERROR, SeverityPreferencesMessages.VALIDATOR_CONFIGURATION_BLOCK_WARNING, SeverityPreferencesMessages.VALIDATOR_CONFIGURATION_BLOCK_IGNORE};
    protected PixelConverter fPixelConverter;
    protected OptionsConfigurationBlock.FilteredPreferenceTree fFilteredPrefTree;
    private ControlEnableState mainBlockEnableState;
    protected Text filterControl;
    protected IWorkbenchPreferenceContainer container;
    protected Button enableCheckBox;
    private Composite commonComposite;

    public SeverityConfigurationBlock(IStatusChangeListener context, IProject project, OptionsConfigurationBlock.Key[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
        this.container = container;
    }

    public IWorkbenchPreferenceContainer getContainer() {
        return this.container;
    }

    protected abstract String getCommonDescription();

    protected abstract SectionDescription[] getAllSections();

    protected abstract IDialogSettings getDialogSettings();

    protected Composite createStyleTabContent(Composite folder) {
        int nColumns = 3;
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite c = new Composite(folder, 0);
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData(768));
        if (this.getMaxNumberOfProblemsKey() != null) {
            this.addMaxNumberOfMarkersField(c);
        }
        this.addWrongBuilderOrderField(c);
        Control[] currentControls = folder.getChildren();
        this.fFilteredPrefTree = new OptionsConfigurationBlock.FilteredPreferenceTree((OptionsConfigurationBlock)this, folder, this.getCommonDescription());
        this.filterControl = this.findText(folder, currentControls.length);
        ScrolledPageContent sc1 = this.fFilteredPrefTree.getScrolledPageContent();
        Composite composite = sc1.getBody();
        composite.setLayout((Layout)layout);
        int defaultIndent = 0;
        SectionDescription[] sectionDescriptionArray = this.getAllSections();
        int n = sectionDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SectionDescription section = sectionDescriptionArray[n2];
            this.createSection(null, section, composite, nColumns, defaultIndent);
            ++n2;
        }
        this.restoreSectionExpansionStates(this.getDialogSettings());
        return sc1;
    }

    Text findText(Composite composite, int startFromIndex) {
        Control[] cs = composite.getChildren();
        int i = startFromIndex;
        while (i < cs.length) {
            Text t;
            Control cl = cs[i];
            if (cl instanceof Text) {
                return (Text)cl;
            }
            if (cl instanceof Composite && (t = this.findText((Composite)cl, 0)) != null) {
                return t;
            }
            ++i;
        }
        return null;
    }

    protected Composite createInnerComposite(ExpandableComposite excomposite, int nColumns, Font font) {
        Composite inner = new Composite((Composite)excomposite, 0);
        inner.setFont(font);
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        excomposite.setClient((Control)inner);
        return inner;
    }

    protected void createSection(OptionsConfigurationBlock.PreferenceTreeNode parent, SectionDescription section, Composite composite, int nColumns, int defaultIndent) {
        String label = section.getLabel();
        OptionsConfigurationBlock.Key twistieKey = OptionsConfigurationBlock.getLocalKey((String)label.replace(' ', '_'));
        OptionsConfigurationBlock.PreferenceTreeNode treeSection = this.fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, parent, false);
        ExpandableComposite excomposite = this.getExpandableComposite(twistieKey);
        Composite inner = this.createInnerComposite(excomposite, nColumns, composite.getFont());
        Object[] objectArray = section.getSections();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            SectionDescription s = objectArray[n2];
            this.createSection(treeSection, s, inner, nColumns, defaultIndent);
            ++n2;
        }
        objectArray = section.getOptions();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object option = objectArray[n2];
            label = ((OptionDescription)option).label;
            this.fFilteredPrefTree.addComboBox(inner, label, ((OptionDescription)option).key, this.errorWarningIgnore, this.errorWarningIgnoreLabels, defaultIndent, treeSection);
            ++n2;
        }
    }

    public void performDefaults() {
        super.performDefaults();
        this.updateMainPreferenceContent();
    }

    protected Button addEnableField(Composite composite) {
        Button checkBox = this.addCheckBox(composite, SeverityPreferencesMessages.ENABLE_VALIDATION, this.getEnableBlockKey(), this.enableDisableValues, 0);
        checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SeverityConfigurationBlock.this.updateMainPreferenceContent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return checkBox;
    }

    protected void addMaxNumberOfMarkersField(Composite composite) {
        Text text = this.addTextField(composite, SeverityPreferencesMessages.MAX_NUMBER_OF_MARKERS, this.getMaxNumberOfProblemsKey(), 0, 0);
        GridData gd = (GridData)text.getLayoutData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(8);
        gd.horizontalAlignment = 1;
        text.setLayoutData((Object)gd);
        text.setTextLimit(6);
    }

    protected void addWrongBuilderOrderField(Composite composite) {
        if (this.getWrongBuilderOrderKey() != null) {
            this.addComboBox(composite, SeverityPreferencesMessages.WRONG_BUILDER_ORDER, this.getWrongBuilderOrderKey(), this.errorWarningIgnore, this.errorWarningIgnoreLabels, 0);
        }
    }

    private IStatus validateMaxNumberProblems() {
        StatusInfo status = new StatusInfo();
        if (this.getMaxNumberOfProblemsKey() != null) {
            String number = this.getValue(this.getMaxNumberOfProblemsKey());
            if (number == null || number.length() == 0) {
                status.setError(PreferencesMessages.JavaBuildConfigurationBlock_empty_input);
            } else {
                try {
                    int value = Integer.parseInt(number);
                    if (value <= 0) {
                        status.setError(Messages.format((String)PreferencesMessages.JavaBuildConfigurationBlock_invalid_input, (Object)number));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    status.setError(Messages.format((String)PreferencesMessages.JavaBuildConfigurationBlock_invalid_input, (Object)number));
                }
            }
        }
        return status;
    }

    protected abstract OptionsConfigurationBlock.Key getEnableBlockKey();

    protected abstract OptionsConfigurationBlock.Key getMaxNumberOfProblemsKey();

    protected OptionsConfigurationBlock.Key getWrongBuilderOrderKey() {
        return null;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        mainComp.setLayoutData((Object)new GridData(768));
        this.enableCheckBox = this.addEnableField(mainComp);
        this.commonComposite = this.createStyleTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels((Control)parent, 20);
        this.commonComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        this.updateMainPreferenceContent();
        return mainComp;
    }

    protected void updateMainPreferenceContent() {
        if (this.enableCheckBox.getSelection()) {
            if (this.mainBlockEnableState != null) {
                this.mainBlockEnableState.restore();
                this.mainBlockEnableState = null;
            }
        } else if (this.mainBlockEnableState == null) {
            this.mainBlockEnableState = ControlEnableState.disable((Control)this.commonComposite);
        }
    }

    private int convertHeightInCharsToPixels(Control control, int chars) {
        Font font = control.getFont();
        GC gc = new GC((Drawable)font.getDevice());
        gc.setFont(font);
        FontMetrics fFontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fFontMetrics, (int)chars);
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = SeverityPreferencesMessages.ValidatorConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? SeverityPreferencesMessages.ValidatorConfigurationBlock_needsfullbuild_message : SeverityPreferencesMessages.ValidatorConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (this.getMaxNumberOfProblemsKey() != null && (changedKey == null || this.getMaxNumberOfProblemsKey().equals(changedKey))) {
            this.fContext.statusChanged(this.validateMaxNumberProblems());
        }
    }

    public Text getFilterControl() {
        return this.filterControl;
    }

    public void doFilter(String prefId) {
        String value;
        Combo combo;
        OptionsConfigurationBlock.Key key = null;
        OptionsConfigurationBlock.Key[] keyArray = this.fAllKeys;
        int n = this.fAllKeys.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsConfigurationBlock.Key k = keyArray[n2];
            if (k.getName().equals(prefId)) {
                key = k;
            }
            ++n2;
        }
        if (key != null && (combo = this.getComboBox(key)) != null && (value = ((Label)this.fLabels.get(combo)).getText()) != null) {
            if (this.filterControl != null) {
                this.filterControl.setText(value);
            } else {
                this.fFilteredPrefTree.doFilter(value);
            }
        }
    }

    protected abstract String getQualifier();

    public static class OptionDescription {
        public String label;
        public OptionsConfigurationBlock.Key key;

        public OptionDescription(String keyName, String label, String pluginId) {
            this.label = label;
            this.key = SeverityConfigurationBlock.getKey((String)pluginId, (String)keyName);
        }
    }

    public static class SectionDescription {
        private String label;
        private SectionDescription[] sections;
        private OptionDescription[] options;

        public SectionDescription(String label, String[][] optionLabelsAndKeys, String pluginId) {
            this(label, new SectionDescription[0], optionLabelsAndKeys, pluginId);
        }

        public SectionDescription(String label, SectionDescription[] sections, String[][] optionLabelsAndKeys, String pluginId) {
            this.label = label;
            this.sections = sections;
            this.options = new OptionDescription[optionLabelsAndKeys.length];
            int i = 0;
            while (i < this.options.length) {
                this.options[i] = new OptionDescription(optionLabelsAndKeys[i][0], optionLabelsAndKeys[i][1], pluginId);
                ++i;
            }
        }

        public String getLabel() {
            return this.label;
        }

        public SectionDescription[] getSections() {
            return this.sections;
        }

        public OptionDescription[] getOptions() {
            return this.options;
        }

        public void collectKeys(ArrayList<OptionsConfigurationBlock.Key> keys) {
            Object[] objectArray = this.sections;
            int n = this.sections.length;
            int n2 = 0;
            while (n2 < n) {
                SectionDescription s = objectArray[n2];
                s.collectKeys(keys);
                ++n2;
            }
            objectArray = this.options;
            n = this.options.length;
            n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                keys.add(((OptionDescription)o).key);
                ++n2;
            }
        }
    }
}

