/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.IValidationContextManager;
import org.jboss.tools.common.validation.IValidator;
import org.jboss.tools.common.validation.ValidationContext;
import org.jboss.tools.common.validation.ValidationMessages;

public class ContextValidationHelper
extends WorkbenchContext {
    private static Storage initializedResourceRegistrators = new Storage();
    protected IValidationContextManager validationContextManager;
    protected TextFileDocumentProvider documentProvider = new TextFileDocumentProvider();

    public void initialize() {
        super.initialize();
        this.cleanup();
    }

    public void deleting() {
        super.deleting();
        this.cleanup();
    }

    public void cleanup(WorkbenchReporter reporter) {
        super.cleanup(reporter);
        this.cleanup();
    }

    public void cleanup() {
        if (this.validationContextManager != null) {
            this.validationContextManager.setValidationResourceRegisters(null);
        }
        this.validationContextManager = null;
        initializedResourceRegistrators.clear();
    }

    public void registerResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (file.isDerived(512)) {
                return;
            }
            if (initializedResourceRegistrators.add(this)) {
                this.validationContextManager = null;
            }
            if (this.validationContextManager == null) {
                this.validationContextManager = new ValidationContext(file.getProject());
            } else if (this.validationContextManager.isObsolete()) {
                this.validationContextManager.init(file.getProject());
            }
            this.validationContextManager.addProject(file.getProject());
            if (!file.exists()) {
                this.validationContextManager.addRemovedFile(file);
            } else {
                this.validationContextManager.registerFile(file);
            }
        }
    }

    public Set<IFile> getChangedFiles() {
        HashSet<IFile> result = new HashSet<IFile>();
        String[] uris = this.getURIs();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Set<IProject> projects = this.getAllProjects();
        int i = 0;
        while (i < uris.length) {
            IFile currentFile;
            if (!uris[i].endsWith(".jar") && !uris[i].endsWith(".classpath") && projects.contains((currentFile = root.getFile((IPath)new Path(uris[i]))).getProject()) && !currentFile.isDerived(512)) {
                result.add(currentFile);
            }
            ++i;
        }
        Set<IFile> removedFiles = this.getValidationContextManager().getRemovedFiles();
        for (IFile file : removedFiles) {
            if (!projects.contains(file.getProject())) continue;
            result.add(file);
        }
        return result;
    }

    public boolean isClasspathAffected() {
        String[] uris;
        String[] stringArray = uris = this.getURIs();
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            if (uri.endsWith(".jar") || uri.endsWith(".classpath")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Set<IFile> getProjectSetRegisteredFiles() {
        HashSet<IFile> result = new HashSet<IFile>();
        Set<IFile> files = this.getValidationContextManager().getRegisteredFiles();
        Set<IProject> projects = this.getAllProjects();
        for (IFile file : files) {
            if (!projects.contains(file.getProject())) continue;
            result.add(file);
        }
        return result;
    }

    private Set<IProject> getAllProjects() {
        IProject project = this.getProject();
        if (!project.isAccessible()) {
            return Collections.emptySet();
        }
        List<IValidator> validators = this.getValidationContextManager().getValidators();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IValidator validator : validators) {
            IValidatingProjectTree tree = validator.getValidatingProjects(project);
            if (tree == null) {
                CommonPlugin.getDefault().logError((Throwable)new IllegalStateException(MessageFormat.format(ValidationMessages.ERR_ILLIGAL_VALIDATION_STATE, validator, this.getProject(), this.getProject().exists())));
                continue;
            }
            projects.addAll(tree.getAllProjects());
        }
        return projects;
    }

    public IValidationContextManager getValidationContextManager() {
        return this.getValidationContextManager(true);
    }

    public IValidationContextManager getValidationContextManager(boolean initialize) {
        if (!initialize) {
            return this.validationContextManager;
        }
        if (this.validationContextManager == null) {
            this.validationContextManager = new ValidationContext(this.getProject());
        }
        return this.validationContextManager;
    }

    public void setValidationContextManager(IValidationContextManager context) {
        this.validationContextManager = context;
    }

    public TextFileDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    private static class Storage {
        Set<ContextValidationHelper> registrators = new HashSet<ContextValidationHelper>();

        private Storage() {
        }

        synchronized boolean add(ContextValidationHelper helper) {
            return this.registrators.add(helper);
        }

        synchronized void clear() {
            this.registrators.clear();
        }
    }
}

