/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.validation.CommonValidationPlugin;
import org.jboss.tools.common.validation.IWarningNameMap;

public class WarningNameManager
implements IWarningNameMap {
    private static final WarningNameManager INSTANCE = new WarningNameManager();
    private Map<String, Set<IConfigurationElement>> allExtensions;
    private Map<String, Set<IWarningNameMap>> maps;
    private Map<String, String[]> warnings;

    public static WarningNameManager getInstance() {
        return INSTANCE;
    }

    private WarningNameManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getWarningNames(String preferenceID) {
        this.init();
        String[] names = null;
        Map<String, String[]> map = this.warnings;
        synchronized (map) {
            names = this.warnings.get(preferenceID);
            if (names == null) {
                String preferenceGoupID = this.getPreferenceGroupID(preferenceID);
                Set<IWarningNameMap> mapsByID = this.maps.get(preferenceGoupID);
                if (mapsByID == null) {
                    mapsByID = new HashSet<IWarningNameMap>();
                    this.maps.put(preferenceGoupID, mapsByID);
                    Set<IConfigurationElement> extns = this.allExtensions.get(preferenceGoupID);
                    if (extns != null) {
                        for (IConfigurationElement element : extns) {
                            try {
                                Object o = element.createExecutableExtension("class");
                                if (o instanceof IWarningNameMap) {
                                    mapsByID.add((IWarningNameMap)o);
                                    continue;
                                }
                                CommonValidationPlugin.getDefault().logError("Extension of org.jboss.tools.common.validation.warnings should refer to an instance of " + IWarningNameMap.class + ". But the actuall class declared in " + element + " refers to " + o.getClass());
                            }
                            catch (CoreException e) {
                                CommonValidationPlugin.getDefault().logError(e);
                            }
                        }
                    }
                }
                if (mapsByID.size() == 1) {
                    names = mapsByID.iterator().next().getWarningNames(preferenceID);
                } else {
                    HashSet<String> mapNameSet = new HashSet<String>();
                    for (IWarningNameMap map2 : mapsByID) {
                        String[] mapNames;
                        String[] stringArray = mapNames = map2.getWarningNames(preferenceID);
                        int n = mapNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String n3 = stringArray[n2];
                            mapNameSet.add(n3);
                            ++n2;
                        }
                    }
                    names = mapNameSet.toArray(new String[mapNameSet.size()]);
                }
                this.warnings.put(preferenceID, names);
            }
        }
        return names;
    }

    private String getPreferenceGroupID(String preferenceID) {
        int dot = preferenceID.lastIndexOf(46);
        return dot > -1 ? preferenceID.substring(0, dot) : preferenceID;
    }

    private synchronized void init() {
        if (this.allExtensions == null) {
            this.maps = new HashMap<String, Set<IWarningNameMap>>();
            this.warnings = new HashMap<String, String[]>();
            this.allExtensions = new HashMap<String, Set<IConfigurationElement>>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.common.validation.warnings");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        String preferenceGroupId = elements[j].getAttribute("preferenceGroupID");
                        Set<IConfigurationElement> els = this.allExtensions.get(preferenceGroupId);
                        if (els == null) {
                            els = new HashSet<IConfigurationElement>();
                            this.allExtensions.put(preferenceGroupId, els);
                        }
                        els.add(elements[j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }
}

