/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;

public class SimpleValidatingProjectTree
implements IValidatingProjectTree,
IValidatingProjectSet {
    private Map<IProject, IValidatingProjectSet> brunches = new HashMap<IProject, IValidatingProjectSet>();
    private IValidatingProjectSet brunch;
    private Set<IProject> validatingProjects = new HashSet<IProject>();

    public SimpleValidatingProjectTree(IProject project) {
        this.addProject(project);
    }

    public SimpleValidatingProjectTree(IValidatingProjectSet brunch) {
        this.brunch = brunch;
        this.brunches.put(brunch.getRootProject(), brunch);
        this.validatingProjects.add(brunch.getRootProject());
    }

    @Override
    public Map<IProject, IValidatingProjectSet> getBrunches() {
        return this.brunches;
    }

    @Override
    public IProject getRootProject() {
        return this.brunch.getRootProject();
    }

    @Override
    public Set<IProject> getAllProjects() {
        return this.brunch.getAllProjects();
    }

    @Override
    public IProjectValidationContext getRootContext() {
        return this.brunch.getRootContext();
    }

    @Override
    public void addProject(IProject project) {
        if (project != null && !this.validatingProjects.contains(project)) {
            HashSet<IProject> allProjects = new HashSet<IProject>();
            allProjects.add(project);
            this.brunch = new ValidatingProjectSet(project, allProjects, new ProjectValidationContext());
            this.brunches.put(this.brunch.getRootProject(), this.brunch);
            this.validatingProjects.add(project);
        }
    }

    @Override
    public boolean isFullValidationRequired() {
        return false;
    }

    @Override
    public void setFullValidationRequired(boolean b) {
    }
}

