/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.ui.vrules.wizard.runtime;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.markers.ResourceProblems;
import org.jboss.tools.common.verification.ui.XStudioVerificationPlugin;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeItemWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeRuleSetWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.VerifyWizardView;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VTaskListener;
import org.jboss.tools.common.verification.vrules.core.resources.VerificationMarkers;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;

public class VTaskListenerImpl
implements VTaskListener {
    private VerifyWizardView view;
    int errors = 0;
    Map<XModelObject, ResourceProblems> problemList = new HashMap<XModelObject, ResourceProblems>();

    public VTaskListenerImpl(VerifyWizardView view) {
        this.view = view;
    }

    public void onStart() {
        this.view.changeControl(VerifyWizardView.RUNNING_COMMANDS);
        this.errors = 0;
    }

    public void onRuleApplied(VRule rule, VObject object, VResult[] results) {
        if (!rule.isEnabled()) {
            return;
        }
        RuntimeItemWrapper w = this.view.findWrapper(rule.getName());
        RuntimeRuleSetWrapper rsw = (RuntimeRuleSetWrapper)this.view.findWrapper(rule.getRuleSet().getName());
        int errorCount = 0;
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                if (results[i] == null) {
                    XStudioVerificationPlugin.getPluginLog().logInfo("Result in rule " + rule.getName() + " is null.");
                } else if (results[i].getSignificance() > VHelper.getManager().getMinSignificance()) {
                    ++errorCount;
                    ++this.errors;
                    if (this.view.getErrorCountLimit() >= 0 && this.errors > this.view.getErrorCountLimit()) {
                        if (this.errors == this.view.getErrorCountLimit() + 1) {
                            this.view.limitReached();
                        }
                    } else {
                        this.addProblem(rule, object, results[i]);
                    }
                }
                ++i;
            }
        } else {
            this.addProblem(rule, object, null);
        }
        if (errorCount == 0) {
            if (w != null) {
                w.mergeStatus(1);
            }
            if (rsw != null) {
                rsw.updateStatus();
            }
        } else if (w != null) {
            w.mergeStatus(2);
            if (rsw != null) {
                rsw.mergeStatus(2);
            }
        }
    }

    public void onRuleFinished(VRule rule, VObject object) {
        this.onRuleApplied(rule, object, null);
    }

    public void onPause() {
        this.view.changeControl(VerifyWizardView.PAUSE_COMMANDS);
    }

    public void onResume() {
        this.view.changeControl(VerifyWizardView.RUNNING_COMMANDS);
    }

    public void onFinish() {
        this.view.changeControl(VerifyWizardView.INITIAL_COMMANDS);
        this.addMarkers();
    }

    void addProblem(VRule rule, VObject object, VResult result) {
        String attr;
        String msg;
        XModelObject o;
        VObjectImpl oi = (VObjectImpl)object;
        XModelObject xModelObject = o = oi == null ? null : oi.getModelObject();
        if (o == null) {
            return;
        }
        XModelObject f = o;
        while (f != null && f.getFileType() != 1) {
            f = f.getParent();
        }
        if (f == null) {
            return;
        }
        ResourceProblems p = this.problemList.get(f);
        String string = msg = result == null ? null : result.getMessage();
        if (p == null) {
            p = new ResourceProblems(f);
            this.problemList.put(f, p);
        }
        Object sp = result == null ? null : result.getSourcePosition();
        String string2 = attr = sp == null ? null : sp.toString();
        if (msg != null) {
            p.addError(o.getPath(), msg, attr, -1);
        }
    }

    void addMarkers() {
        for (ResourceProblems p : this.problemList.values()) {
            VerificationMarkers markers = new VerificationMarkers(p);
            markers.setModelObject(p.getResourceObject());
            markers.update();
        }
    }
}

