/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.handler.VerifyHandler;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;

public class VerifyRuleHandler
extends VerifyHandler {
    protected VRule rule;

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        VModel vmodel = VModelFactory.getModel(object.getModel());
        HashMap<String, ArrayList<VRule>> entities = new HashMap<String, ArrayList<VRule>>();
        VEntity[] ent = this.rule.getEntities();
        int j = 0;
        while (j < ent.length) {
            String name = ent[j].getName();
            ArrayList<VRule> r = (ArrayList<VRule>)entities.get(name);
            if (r == null) {
                r = new ArrayList<VRule>();
                entities.put(name, r);
            }
            r.add(this.rule);
            ++j;
        }
        VObject vobject = vmodel.getObjectByPath(object.getPath());
        this.check(entities, vobject, object.getModel());
    }

    public boolean isEnabled(XModelObject object) {
        return this.rule != null && this.rule.isEnabled() && this.rule.getRuleSet().isEnabled() && this.rule.getAction() != null;
    }

    public VRule getRule() {
        return this.rule;
    }

    public void setRule(VRule rule) {
        this.rule = rule;
    }
}

