/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.refactoring;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;

public abstract class BaseMarkerResolution
implements IQuickFix {
    protected String label;
    protected String description;
    protected ICompilationUnit cUnit;

    public BaseMarkerResolution(ICompilationUnit compilationUnit) {
        this.cUnit = compilationUnit;
    }

    protected final void init() {
        this.description = this.getPreview();
    }

    public final String getLabel() {
        return this.label;
    }

    protected void do_run(boolean leaveDirty) {
        try {
            if (this.cUnit != null) {
                ICompilationUnit compilationUnit = this.cUnit.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                TextFileChange change = this.getChange(compilationUnit);
                if (change.getEdit().hasChildren()) {
                    if (leaveDirty) {
                        change.setSaveMode(4);
                    }
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                    this.cUnit.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
                compilationUnit.discardWorkingCopy();
            }
        }
        catch (CoreException ex) {
            CommonPlugin.getDefault().logError(ex);
        }
    }

    public final void run(IMarker marker) {
        this.do_run(false);
    }

    public final String getDescription() {
        return this.description;
    }

    private TextChange getPreviewChange() {
        if (this.cUnit != null) {
            try {
                ICompilationUnit compilationUnit = this.cUnit.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                TextFileChange change = this.getChange(compilationUnit);
                compilationUnit.discardWorkingCopy();
                return change;
            }
            catch (JavaModelException e) {
                CommonPlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    private String getPreview() {
        TextChange previewChange = this.getPreviewChange();
        if (previewChange != null) {
            try {
                return MarkerResolutionUtils.getPreview((Change)previewChange);
            }
            catch (CoreException e) {
                CommonPlugin.getDefault().logError(e);
            }
        }
        return this.label;
    }

    public void apply(IDocument document) {
        this.do_run(true);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public String getDisplayString() {
        return this.label;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 100;
    }

    protected abstract TextFileChange getChange(ICompilationUnit var1);
}

