/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.common.util.FileUtils;

public final class FileUtil
extends FileUtils {
    public static String getContentFromEditorOrFile(IFile file) {
        IFileEditorInput fileInput;
        IEditorInput editorInput;
        IDocument doc;
        IFileBuffer b = FileBuffers.getTextFileBufferManager().getFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (b instanceof ITextFileBuffer && (doc = ((ITextFileBuffer)b).getDocument()) != null) {
            return doc.get();
        }
        ITextEditor editor = EclipseUIUtil.getActiveEditor();
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)(fileInput = (IFileEditorInput)editorInput).getFile())) {
            IDocumentProvider dp = editor.getDocumentProvider();
            try {
                dp.connect((Object)fileInput);
                IDocument doc2 = dp.getDocument((Object)fileInput);
                String string = doc2.get();
                return string;
            }
            catch (CoreException e) {
                CommonPlugin.getDefault().logError(e);
            }
            finally {
                dp.disconnect((Object)fileInput);
            }
        }
        if (!file.isSynchronized(0)) {
            if (file.exists() && file.getLocation() != null) {
                return FileUtil.readFile((File)file.getLocation().toFile());
            }
            return null;
        }
        try {
            return FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError(e);
            return null;
        }
    }

    public static boolean isDoctypeHTML(IFile file) {
        return FileUtil.isDoctypeHTML(FileUtil.getContentFromEditorOrFile(file));
    }

    public static boolean isDoctypeHTML(String content) {
        return "html".equalsIgnoreCase(FileUtil.getDoctype(content));
    }

    public static String getDoctype(String content) {
        int j;
        int i = 0;
        while ((i = content.indexOf("<!", i)) >= 0 && (j = content.indexOf(">", i)) >= 0) {
            String dt1;
            if (j > i + 4 && content.substring(i + 2, i + 4).equals("--")) {
                if ((i = content.indexOf("-->", i + 4)) < 0) break;
                i += 3;
                continue;
            }
            if (content.indexOf("<!", i + 1) > i && content.indexOf("<!", i + 1) < j) {
                i += 2;
                continue;
            }
            if (j <= i + 10 || !"doctype".equalsIgnoreCase(dt1 = content.substring(i + 2, i + 9).trim())) break;
            String dt = content.substring(i + 9, j).trim();
            return dt;
        }
        return null;
    }

    public static boolean isHTMLFile(IFile file) {
        String name = file.getFileExtension().toLowerCase();
        return name.equals("html") || name.equals("htm");
    }
}

