/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.console;

import java.beans.PropertyChangeEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.tools.aesh.core.console.Console;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.ui.internal.actions.ClearAction;
import org.jboss.tools.forge.ui.internal.actions.GoToAction;
import org.jboss.tools.forge.ui.internal.actions.LinkAction;
import org.jboss.tools.forge.ui.internal.actions.StartAction;
import org.jboss.tools.forge.ui.internal.actions.StopAction;
import org.jboss.tools.forge.ui.internal.console.AbstractForgeConsole;
import org.jboss.tools.forge.ui.internal.viewer.F2TextViewer;
import org.jboss.tools.forge.ui.internal.viewer.ForgeTextViewer;

public class F2Console
extends AbstractForgeConsole {
    private F2TextViewer textViewer;

    public F2Console(ForgeRuntime runtime) {
        super(runtime);
    }

    @Override
    public ForgeTextViewer createTextViewer(Composite parent) {
        this.textViewer = new F2TextViewer(parent);
        return this.textViewer;
    }

    @Override
    public IAction[] createActions() {
        return new IAction[]{new StartAction(this.getRuntime()), new StopAction(this.getRuntime()), new GoToAction(this.getRuntime()), new ClearAction(this.getRuntime()), new LinkAction(this.getRuntime())};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (ForgeRuntimeState.RUNNING.equals(evt.getNewValue())) {
            this.getTextViewer().startConsole();
        }
        if (ForgeRuntimeState.STOPPED.equals(evt.getNewValue())) {
            this.getTextViewer().stopConsole();
        }
    }

    @Override
    public Resource<?> getCurrentResource() {
        Resource currentResource = null;
        Console console = this.getConsole();
        if (console != null) {
            currentResource = (Resource)console.getCurrentResource();
        }
        return currentResource;
    }

    @Override
    public void goToPath(String path) {
        Console console = this.getConsole();
        if (console != null) {
            console.sendInput("cd " + path.replaceAll(" ", "\\\\ ") + " " + System.lineSeparator());
        }
    }

    @Override
    public void clear() {
        Console console = this.getConsole();
        if (console != null) {
            console.sendInput("clear" + System.lineSeparator());
        }
    }

    private Console getConsole() {
        return this.textViewer != null ? this.textViewer.getConsole() : null;
    }
}

