/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials;

import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.foundation.core.credentials.CredentialService;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.ui.credentials.ChooseCredentialComponent;
import org.jboss.tools.foundation.ui.credentials.ICredentialCompositeListener;
import org.jboss.tools.foundation.ui.internal.FoundationUIPlugin;

public class ChooseCredentialOverridePasswordComponent
extends ChooseCredentialComponent
implements ICredentialCompositeListener {
    private Text passwordText;
    private Label passwordLabel;
    private ModifyListener passwordModifyListener;
    private boolean modifyingPassword;
    private boolean passwordModified = false;

    public ChooseCredentialOverridePasswordComponent() {
        this(null);
    }

    public ChooseCredentialOverridePasswordComponent(String[] domains) {
        this(domains, null);
    }

    public ChooseCredentialOverridePasswordComponent(String[] domains, String selectedUsername) {
        super(domains, selectedUsername);
        this.addCredentialListener(this);
    }

    @Override
    public void create(Composite parent) {
        super.create(parent);
        this.credentialsChanged();
    }

    @Override
    protected void createWidgets(Composite parent) {
        super.createWidgets(parent);
        this.passwordLabel = new Label(parent, 0);
        this.passwordLabel.setText("Password: ");
        this.passwordText = new Text(parent, 0x400800);
    }

    @Override
    protected void addWidgetListeners() {
        super.addWidgetListeners();
        this.passwordModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseCredentialOverridePasswordComponent.this.modifyingPassword = true;
                ChooseCredentialOverridePasswordComponent.this.passwordModified = true;
                try {
                    ChooseCredentialOverridePasswordComponent.this.fireChanged();
                }
                finally {
                    ChooseCredentialOverridePasswordComponent.this.modifyingPassword = false;
                }
            }
        };
        this.passwordText.addModifyListener(this.passwordModifyListener);
    }

    @Override
    public String getPassword() {
        ICredentialDomain cd = this.getDomain();
        if (this.passwordModified || CredentialService.getCredentialModel().credentialRequiresPrompt(cd, this.getUser())) {
            return this.passwordText.getText();
        }
        if (cd != null) {
            try {
                return cd.getPassword(this.getUser());
            }
            catch (StorageException se) {
                FoundationUIPlugin.pluginLog().logError((Throwable)se);
            }
        }
        return null;
    }

    @Override
    public void gridLayout(int n) {
        super.gridLayout(n);
        if (n == 2) {
            GridData gd2 = new GridData();
            gd2.widthHint = 200;
            this.passwordText.setLayoutData((Object)gd2);
        } else if (n >= 3) {
            GridData passwordData = new GridData();
            passwordData.widthHint = 200;
            passwordData.horizontalSpan = n - 1;
            passwordData.horizontalAlignment = 4;
            this.passwordText.setLayoutData((Object)passwordData);
        }
    }

    @Override
    protected boolean showEditButton() {
        return false;
    }

    @Override
    public void credentialsChanged() {
        block8: {
            if (this.modifyingPassword) {
                return;
            }
            String user = this.getUser();
            ICredentialDomain cd = this.getDomain();
            if (user != null && cd != null) {
                boolean requiresPrompt = CredentialService.getCredentialModel().credentialRequiresPrompt(cd, user);
                this.passwordText.removeModifyListener(this.passwordModifyListener);
                try {
                    try {
                        if (requiresPrompt) {
                            this.passwordText.setText("");
                            break block8;
                        }
                        this.passwordText.setText(cd.getPassword(user));
                    }
                    catch (StorageException storageException) {
                        this.passwordText.addModifyListener(this.passwordModifyListener);
                    }
                }
                finally {
                    this.passwordText.addModifyListener(this.passwordModifyListener);
                }
            }
        }
    }
}

