/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.foundation.core.credentials.CredentialService;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.ui.credentials.internal.CredentialMessages;
import org.jboss.tools.foundation.ui.credentials.internal.FaviconCache;
import org.jboss.tools.foundation.ui.credentials.internal.NewCredentialDomainDialog;
import org.jboss.tools.foundation.ui.credentials.internal.NewCredentialUserDialog;
import org.jboss.tools.foundation.ui.internal.FoundationUIPlugin;
import org.jboss.tools.foundation.ui.util.FormDataUtility;

public class CredentialPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button addDomainButton;
    private Button removeDomainButton;
    private Button addUserButton;
    private Button removeUserButton;
    private Button editButton;
    private TreeViewer tv;

    public CredentialPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public CredentialPreferencePage(String title) {
        super(title);
    }

    public CredentialPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    private static Comparator<CredentialUser> getCredentialUserComparator() {
        return new CredentialUserComparator();
    }

    private ITreeContentProvider createContentProvider() {
        return new CredentialTreeContentProvider();
    }

    private LabelProvider createLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                CredentialUser cu;
                if (element instanceof CredentialUser && (cu = (CredentialUser)element).user.equals(cu.domain.getDefaultUsername())) {
                    return FoundationUIPlugin.getDefault().getSharedImages().image("icons/greencheck_16.png");
                }
                if (element instanceof ICredentialDomain) {
                    ICredentialDomain cd = (ICredentialDomain)element;
                    String host = cd.getName();
                    Image i = FaviconCache.getDefault().getImageForHost(host);
                    if (i != null) {
                        return i;
                    }
                    if (!FaviconCache.getDefault().loadFailed(host)) {
                        FaviconCache.FaviconCacheListener l = new FaviconCache.FaviconCacheListener(){

                            @Override
                            public void iconCached(String host) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        CredentialPreferencePage.this.tv.refresh();
                                    }
                                });
                            }

                            @Override
                            public void fetchFailed(String host) {
                            }
                        };
                        FaviconCache.getDefault().loadFavicon(host, l);
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ICredentialDomain) {
                    return ((ICredentialDomain)element).getName();
                }
                if (element instanceof CredentialUser) {
                    return ((CredentialUser)element).user;
                }
                return element == null ? "" : element.toString();
            }
        };
    }

    protected Control createContents(Composite parent) {
        Composite mine = new Composite(parent, 0);
        mine.setLayout((Layout)new FormLayout());
        this.tv = new TreeViewer(mine, 2820);
        this.tv.setContentProvider((IContentProvider)this.createContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.tv.setInput((Object)ResourcesPlugin.getWorkspace());
        this.tv.getTree().setLayoutData((Object)new FormDataUtility().createFormData(0, 5, 100, -5, 0, 5, 80, -5));
        this.addDomainButton = new Button(mine, 8);
        this.removeDomainButton = new Button(mine, 8);
        this.addUserButton = new Button(mine, 8);
        this.removeUserButton = new Button(mine, 8);
        this.editButton = new Button(mine, 8);
        this.addDomainButton.setText(CredentialMessages.AddDomain);
        this.removeDomainButton.setText(CredentialMessages.RemoveDomain);
        this.addUserButton.setText(CredentialMessages.AddUser);
        this.removeUserButton.setText(CredentialMessages.RemoveUser);
        this.editButton.setText(CredentialMessages.Edit);
        this.addDomainButton.setLayoutData((Object)new FormDataUtility().createFormData(0, 5, null, 0, 80, 5, 100, -5));
        this.removeDomainButton.setLayoutData((Object)new FormDataUtility().createFormData(this.addDomainButton, 5, null, 0, 80, 5, 100, -5));
        this.addUserButton.setLayoutData((Object)new FormDataUtility().createFormData(this.removeDomainButton, 5, null, 0, 80, 5, 100, -5));
        this.removeUserButton.setLayoutData((Object)new FormDataUtility().createFormData(this.addUserButton, 5, null, 0, 80, 5, 100, -5));
        this.editButton.setLayoutData((Object)new FormDataUtility().createFormData(this.removeUserButton, 5, null, 0, 80, 5, 100, -5));
        this.removeUserButton.setEnabled(false);
        this.removeDomainButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CredentialPreferencePage.this.tv.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)CredentialPreferencePage.this.tv.getSelection();
                    Object selected = ss.getFirstElement();
                    if (selected != null) {
                        if (selected instanceof ICredentialDomain) {
                            boolean noUsers = ((ICredentialDomain)selected).getUsernames().length <= 1;
                            CredentialPreferencePage.this.editButton.setEnabled(!noUsers);
                            ICredentialDomain domain = (ICredentialDomain)selected;
                            CredentialPreferencePage.this.addDomainButton.setEnabled(true);
                            CredentialPreferencePage.this.addUserButton.setEnabled(true);
                            CredentialPreferencePage.this.removeDomainButton.setEnabled(domain.getRemovable() && domain.getUsernames().length == 0);
                            CredentialPreferencePage.this.removeUserButton.setEnabled(false);
                        } else if (selected instanceof CredentialUser) {
                            CredentialPreferencePage.this.editButton.setEnabled(true);
                            CredentialPreferencePage.this.addDomainButton.setEnabled(true);
                            CredentialPreferencePage.this.addUserButton.setEnabled(true);
                            CredentialPreferencePage.this.removeDomainButton.setEnabled(false);
                            CredentialPreferencePage.this.removeUserButton.setEnabled(true);
                        }
                    } else {
                        CredentialPreferencePage.this.addDomainButton.setEnabled(true);
                        CredentialPreferencePage.this.addUserButton.setEnabled(true);
                        CredentialPreferencePage.this.removeDomainButton.setEnabled(false);
                        CredentialPreferencePage.this.removeUserButton.setEnabled(false);
                        CredentialPreferencePage.this.editButton.setEnabled(false);
                    }
                }
            }
        });
        this.addDomainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialPreferencePage.this.addDomainPressed();
            }
        });
        this.removeDomainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialPreferencePage.this.removeDomainPressed();
            }
        });
        this.addUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialPreferencePage.this.addUserPressed();
            }
        });
        this.removeUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialPreferencePage.this.removeUserPressed();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialPreferencePage.this.editPressed();
            }
        });
        return mine;
    }

    private void addDomainPressed() {
        NewCredentialDomainDialog dialog = new NewCredentialDomainDialog(this.getShell(), CredentialService.getCredentialModel());
        if (dialog.open() == 0) {
            String name = dialog.getDomainName();
            if (name != null && !name.isEmpty()) {
                CredentialService.getCredentialModel().addDomain(name, name, true);
                CredentialService.getCredentialModel().save();
            }
            this.tv.refresh();
        }
    }

    private void removeDomainPressed() {
        ICredentialDomain domain;
        IStructuredSelection ss = (IStructuredSelection)this.tv.getSelection();
        Object selected = ss.getFirstElement();
        if (selected instanceof ICredentialDomain && (domain = (ICredentialDomain)selected).getRemovable() && domain.getUsernames().length == 0) {
            if (!CredentialService.getCredentialModel().save()) {
                MessageDialog.openWarning((Shell)this.removeUserButton.getShell(), (String)CredentialMessages.Warning, (String)CredentialMessages.UnableToDeleteCredentials);
                return;
            }
            CredentialService.getCredentialModel().removeDomain(domain);
            CredentialService.getCredentialModel().save();
            this.tv.refresh();
        }
    }

    private void editPressed() {
        IStructuredSelection ss = (IStructuredSelection)this.tv.getSelection();
        Object selected = ss.getFirstElement();
        if (selected instanceof CredentialUser) {
            this.editUserPressed((CredentialUser)selected);
        } else if (selected instanceof ICredentialDomain) {
            this.editDomainPressed((ICredentialDomain)selected);
        }
    }

    private void editDomainPressed(ICredentialDomain domain) {
        NewCredentialDomainDialog dialog = new NewCredentialDomainDialog(this.getShell(), CredentialService.getCredentialModel(), domain);
        if (dialog.open() == 0) {
            CredentialService.getCredentialModel().setDefaultCredential(domain, dialog.getDefaultUser());
            CredentialService.getCredentialModel().save();
            this.tv.refresh();
        }
    }

    private void editUserPressed(CredentialUser u) {
        NewCredentialUserDialog dialog = new NewCredentialUserDialog(this.getShell(), CredentialService.getCredentialModel(), u.domain, u.user);
        if (dialog.open() == 0) {
            String name = dialog.getUser();
            String pass = dialog.getPass();
            CredentialService.getCredentialModel().removeCredentials(u.domain, u.user);
            if (dialog.isAlwaysPrompt()) {
                CredentialService.getCredentialModel().addPromptedCredentials(u.domain, u.user);
            } else {
                CredentialService.getCredentialModel().addCredentials(u.domain, name, pass);
            }
            CredentialService.getCredentialModel().save();
            this.tv.refresh();
        }
    }

    private void addUserPressed() {
        IStructuredSelection ss = (IStructuredSelection)this.tv.getSelection();
        Object selected = ss.getFirstElement();
        ICredentialDomain selectedDomain = null;
        if (selected instanceof ICredentialDomain) {
            selectedDomain = (ICredentialDomain)selected;
        } else if (selected instanceof CredentialUser) {
            selectedDomain = ((CredentialUser)selected).domain;
        }
        NewCredentialUserDialog dialog = new NewCredentialUserDialog(this.getShell(), CredentialService.getCredentialModel(), selectedDomain);
        if (dialog.open() == 0) {
            ICredentialDomain cd = dialog.getDomain();
            String name = dialog.getUser();
            String pass = dialog.getPass();
            if (dialog.isAlwaysPrompt()) {
                CredentialService.getCredentialModel().addPromptedCredentials(cd, name);
            } else {
                CredentialService.getCredentialModel().addCredentials(cd, name, pass);
            }
            CredentialService.getCredentialModel().save();
            this.tv.refresh();
        }
    }

    private void removeUserPressed() {
        IStructuredSelection ss = (IStructuredSelection)this.tv.getSelection();
        Object selected = ss.getFirstElement();
        if (selected instanceof CredentialUser) {
            if (!CredentialService.getCredentialModel().save()) {
                MessageDialog.openWarning((Shell)this.removeUserButton.getShell(), (String)CredentialMessages.Warning, (String)CredentialMessages.UnableToDeleteCredentials);
                return;
            }
            CredentialService.getCredentialModel().removeCredentials(((CredentialUser)selected).domain, ((CredentialUser)selected).user);
            CredentialService.getCredentialModel().save();
            this.tv.refresh();
        }
    }

    private static class CredentialTreeContentProvider
    implements ITreeContentProvider {
        private CredentialTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return CredentialService.getCredentialModel().getDomains();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ICredentialDomain) {
                ICredentialDomain p = (ICredentialDomain)parentElement;
                String[] all = ((ICredentialDomain)parentElement).getUsernames();
                ArrayList<CredentialUser> ret = new ArrayList<CredentialUser>(all.length);
                int i = 0;
                while (i < all.length) {
                    ret.add(new CredentialUser(p, all[i]));
                    ++i;
                }
                Collections.sort(ret, CredentialPreferencePage.getCredentialUserComparator());
                return ret.toArray(new CredentialUser[ret.size()]);
            }
            return new Object[0];
        }
    }

    private static class CredentialUser {
        private ICredentialDomain domain;
        private String user;

        public CredentialUser(ICredentialDomain domain, String user) {
            this.domain = domain;
            this.user = user;
        }
    }

    private static class CredentialUserComparator
    implements Comparator<CredentialUser> {
        private CredentialUserComparator() {
        }

        @Override
        public int compare(CredentialUser o1, CredentialUser o2) {
            int ret = 0;
            String defaultUser = o1.domain.getDefaultUsername();
            if (defaultUser != null) {
                ret = o1.user.equals(defaultUser) ? -1 : (o2.user.equals(defaultUser) ? 1 : o1.user.compareTo(o2.user));
            }
            return ret;
        }
    }
}

