/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials.internal;

import org.eclipse.ui.PlatformUI;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.core.credentials.ICredentialsPrompter;
import org.jboss.tools.foundation.ui.credentials.internal.CredentialPromptDialog;

public class CredentialsPrompter
implements ICredentialsPrompter {
    private ICredentialDomain domain;
    private String initialUser;
    private String selectedUser;
    private String selectedPassword;
    private boolean canChangeUser;
    private boolean saveChanges;

    public void init(ICredentialDomain domain, String user, boolean canChangeUser) {
        this.domain = domain;
        this.initialUser = user;
        this.canChangeUser = canChangeUser;
    }

    public void prompt() {
        final CredentialPromptDialog loginDialog = new CredentialPromptDialog(this.domain, this.initialUser, this.canChangeUser);
        final String[] result = new String[2];
        final Boolean[] saveChanges = new Boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (loginDialog.open() == 0) {
                    result[0] = loginDialog.getUser();
                    result[1] = loginDialog.getPassword();
                    saveChanges[0] = loginDialog.getSaveChanges();
                } else {
                    result[0] = null;
                    result[1] = null;
                    saveChanges[0] = false;
                }
            }
        });
        this.selectedUser = result[0];
        this.selectedPassword = result[1];
        this.saveChanges = saveChanges[0];
    }

    public String getUsername() {
        return this.selectedUser;
    }

    public String getPassword() {
        return this.selectedPassword;
    }

    public boolean saveChanges() {
        return this.saveChanges;
    }
}

