/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.widget;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.foundation.ui.widget.IWidgetVisitor;

public class WidgetVisitorUtility {
    public static final int DEPTH_FIRST = 1;
    public static final int BREADTH_FIRST = 2;
    private int traversal;
    private boolean visitRoot;

    public WidgetVisitorUtility() {
        this(2);
    }

    public WidgetVisitorUtility(int traversal) {
        this(traversal, true);
    }

    public WidgetVisitorUtility(boolean visitRoot) {
        this(2, visitRoot);
    }

    public WidgetVisitorUtility(int traversal, boolean visitRoot) {
        this.traversal = traversal;
        this.visitRoot = visitRoot;
    }

    public void setEnablementRecursive(Composite composite, final boolean enabled) {
        this.accept(composite, new IWidgetVisitor(){

            @Override
            public boolean visit(Control control) {
                if (!control.isDisposed()) {
                    control.setEnabled(enabled);
                }
                return true;
            }
        });
    }

    public void setEnablementRecursive(Composite composite, boolean enabled, Control[] ignored) {
        int i;
        if (ignored == null) {
            this.setEnablementRecursive(composite, enabled);
            return;
        }
        boolean[] status = new boolean[ignored.length];
        if (status != null) {
            i = 0;
            while (i < status.length) {
                status[i] = ignored[i].getEnabled();
                ++i;
            }
        }
        this.setEnablementRecursive(composite, enabled);
        i = 0;
        while (i < ignored.length) {
            ignored[i].setEnabled(status[i]);
            if (status[i]) {
                Composite c = ignored[i].getParent();
                while (c != null) {
                    if (c.isDisposed()) continue;
                    c.setEnabled(true);
                    c = c.getParent();
                }
            }
            ++i;
        }
    }

    public void accept(Composite composite, IWidgetVisitor visitor) {
        this.accept(composite, visitor, this.traversal == 1, this.visitRoot);
    }

    private void accept(Composite composite, IWidgetVisitor visitor, boolean depthFirst, boolean visitRoot) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] children = composite.getChildren();
        boolean traverseChildren = true;
        if (!depthFirst && visitRoot) {
            traverseChildren = visitor.visit((Control)composite);
        }
        if (traverseChildren) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Composite) {
                    this.accept((Composite)children[i], visitor, depthFirst, true);
                } else {
                    visitor.visit(children[i]);
                }
                ++i;
            }
        }
        if (depthFirst && visitRoot) {
            visitor.visit((Control)composite);
        }
    }
}

