/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.importer;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.resource.persistence.PersistenceXmlResourceProvider;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.eclipse.ui.wizards.datatransfer.RecursiveFileFinder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.hibernate.jpt.ui.HibernateJptUIPlugin;

public class JPAProjectConfigurator
implements ProjectConfigurator {
    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            RecursiveFileFinder finder = new RecursiveFileFinder("persistence.xml", ignoredDirectories);
            project.accept((IResourceVisitor)finder);
            return finder.getFile() != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
            IProjectFacet JPA_FACET = ProjectFacetsManager.getProjectFacet((String)"jpt.jpa");
            if (!facetedProject.hasProjectFacet(JPA_FACET)) {
                LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>(2, 1.0f);
                IProjectFacetVersion javaFv = JavaFacet.FACET.getVersion(JavaFacetUtil.getCompilerLevel((IProject)project));
                if (!facetedProject.hasProjectFacet(JavaFacet.FACET)) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javaFv, null));
                } else if (!facetedProject.hasProjectFacet(javaFv)) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, javaFv, null));
                }
                RecursiveFileFinder finder = new RecursiveFileFinder("persistence.xml", ignoredDirectories);
                project.accept((IResourceVisitor)finder);
                PersistenceXmlResourceProvider provider = PersistenceXmlResourceProvider.getXmlResourceProvider((IFile)finder.getFile());
                JptXmlResource jpaXmlResource = provider.getXmlResource();
                IProjectFacetVersion version = null;
                if (jpaXmlResource.getVersion() != null) {
                    version = JpaProject.FACET.getVersion(jpaXmlResource.getVersion());
                }
                if (version == null) {
                    version = JpaProject.FACET.getLatestVersion();
                }
                Object platform = null;
                LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)facetedProject, version);
                ILibraryProvider libraryProvider = LibraryProviderFramework.getProvider((String)"jpa-no-op-library-provider");
                libraryDelegate.setLibraryProvider(libraryProvider);
                IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
                dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)version.getVersionString());
                dm.setProperty("JpaFacetDataModelProperties.PLATFORM", platform);
                dm.setProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", (Object)true);
                dm.setProperty("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, version, (Object)dm));
                facetedProject.modify(actions, monitor);
            }
        }
        catch (Exception ex) {
            HibernateJptUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.hibernate.jpt.ui", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return false;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        return Collections.emptySet();
    }
}

