/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

abstract class StateController {
    private PropertyChangeListener booleanChangeListener;
    private PropertyValueModel<Boolean> booleanHolder;
    private Collection<ControlHolder> controlHolders;
    private boolean defaultValue;

    StateController() {
        this.initialize();
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Collection<ControlHolder> controlHolders) {
        this(booleanHolder, controlHolders, false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Collection<ControlHolder> controlHolders, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, controlHolders, defaultValue);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, ControlHolder controlHolder) {
        this(booleanHolder, controlHolder, false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, ControlHolder ... controlHolders) {
        this(booleanHolder, (Collection<ControlHolder>)CollectionTools.identityHashBag((Object[])controlHolders), false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, ControlHolder controlHolder, boolean defaultValue) {
        this(booleanHolder, new ControlHolder[]{controlHolder}, false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, ControlHolder[] controlHolders, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, (Collection<ControlHolder>)CollectionTools.identityHashBag((Object[])controlHolders), defaultValue);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Iterator<ControlHolder> controlHolders) {
        this(booleanHolder, (Collection<ControlHolder>)CollectionTools.identityHashBag(controlHolders), false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Iterator<ControlHolder> controlHolders, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, (Collection<ControlHolder>)CollectionTools.identityHashBag(controlHolders), defaultValue);
    }

    protected boolean booleanValue(Boolean value) {
        return value == null ? this.defaultValue : value;
    }

    private PropertyChangeListener buildBooleanChangeListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)this.buildBooleanChangeListener_());
    }

    private PropertyChangeListener buildBooleanChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                StateController.this.updateState();
            }

            public String toString() {
                return "StateController.PropertyChangeListener";
            }
        };
    }

    protected final Iterator<ControlHolder> controlHolders() {
        return IteratorTools.clone(this.controlHolders);
    }

    protected void initialize() {
        this.booleanChangeListener = this.buildBooleanChangeListener();
    }

    protected void initialize(PropertyValueModel<Boolean> booleanHolder, Collection<ControlHolder> controlHolders, boolean defaultValue) {
        Assert.isNotNull(booleanHolder, (String)"The holder of the boolean value cannot be null");
        Assert.isNotNull(controlHolders, (String)"The collection of ControlHolders cannot be null");
        this.controlHolders = new ArrayList<ControlHolder>(controlHolders);
        this.defaultValue = defaultValue;
        this.booleanHolder = booleanHolder;
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.updateState();
    }

    protected void updateState() {
        this.updateState(this.booleanValue((Boolean)this.booleanHolder.getValue()));
    }

    protected void updateState(boolean state) {
        for (ControlHolder controlHolder : this.controlHolders) {
            controlHolder.updateState(state);
        }
    }

    static interface ControlHolder {
        public void updateState(boolean var1);
    }
}

