/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.widgets;

import java.util.Collection;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;
import org.jboss.tools.hibernate.jpt.ui.internal.widgets.NameStateObject;

public class EnterNameDialog
extends ValidatingDialog<NameStateObject> {
    private String description;
    private Image descriptionImage;
    private String descriptionTitle;
    private String labelText;
    private String name;
    private Collection<String> names;

    public EnterNameDialog(Shell parentShell, ResourceManager resourceManager, String descriptionTitle) {
        this(parentShell, resourceManager, descriptionTitle, null, null);
    }

    public EnterNameDialog(Shell parentShell, ResourceManager resourceManager, String descriptionTitle, String name, Collection<String> names) {
        this(parentShell, resourceManager, HibernateUIMappingMessages.EnterNameDialog_title, descriptionTitle, null, null, HibernateUIMappingMessages.EnterNameDialog_labelText, name, names);
    }

    public EnterNameDialog(Shell parentShell, ResourceManager resourceManager, String dialogTitle, String descriptionTitle, Image descriptionImage, String description, String labelText, String name, Collection<String> names) {
        super(parentShell, resourceManager, dialogTitle);
        this.name = name;
        this.labelText = labelText;
        this.description = description;
        this.descriptionImage = descriptionImage;
        this.descriptionTitle = descriptionTitle;
        this.names = names;
    }

    protected DialogPane<NameStateObject> buildLayout(Composite container) {
        return new NewNameDialogPane(container);
    }

    protected NameStateObject buildStateObject() {
        return new NameStateObject(this.name, this.names);
    }

    public void create() {
        super.create();
        NewNameDialogPane pane = (NewNameDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    protected String getDescription() {
        return this.description;
    }

    protected Image getDescriptionImage() {
        return this.descriptionImage;
    }

    protected String getDescriptionTitle() {
        return this.descriptionTitle;
    }

    public String getName() {
        return ((NameStateObject)this.getSubject()).getName();
    }

    private class NewNameDialogPane
    extends DialogPane<NameStateObject> {
        private Text text;

        NewNameDialogPane(Composite parent) {
            super(EnterNameDialog.this.getSubjectHolder(), parent, EnterNameDialog.this.resourceManager);
        }

        private ModifiablePropertyValueModel<String> buildNameHolder() {
            return new PropertyAspectAdapter<NameStateObject, String>(this.getSubjectHolder(), new String[]{"nameProperty"}){

                protected String buildValue_() {
                    return ((NameStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((NameStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        protected void initializeLayout(Composite container) {
            this.addLabel(container, EnterNameDialog.this.labelText);
            this.text = this.addText(container, this.buildNameHolder(), null);
        }

        void selectAll() {
            this.text.selectAll();
        }
    }
}

