/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.wizard;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

class NewJavaFilesListener
implements IResourceChangeListener {
    List<IResource> generatedJavaFiles = new LinkedList<IResource>();
    private List<IPackageFragmentRoot> sourceRoots = new LinkedList<IPackageFragmentRoot>();

    public NewJavaFilesListener(IJavaProject project) {
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = project.getAllPackageFragmentRoots();
            int j = 0;
            while (j < allPackageFragmentRoots.length) {
                if (!allPackageFragmentRoots[j].isArchive()) {
                    this.sourceRoots.add(allPackageFragmentRoots[j]);
                }
                ++j;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IFile candidate;
                        IResource resource = delta.getResource();
                        int type = resource.getType();
                        if (type == 8 || type == 4 || type == 2) {
                            return true;
                        }
                        if (resource instanceof IFile && delta.getKind() == 1 && this.isJavaSourceFile((IResource)(candidate = (IFile)resource))) {
                            NewJavaFilesListener.this.generatedJavaFiles.add((IResource)candidate);
                        }
                        return false;
                    }

                    private boolean isJavaSourceFile(IResource candidate) {
                        if (candidate.getName().endsWith(".java")) {
                            while (candidate.getParent() != null) {
                                for (IPackageFragmentRoot root : NewJavaFilesListener.this.sourceRoots) {
                                    if (!root.getResource().equals((Object)candidate.getParent())) continue;
                                    return true;
                                }
                                candidate = candidate.getParent();
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

