/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.Properties;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IConfiguration;
import org.jboss.tools.hibernate.runtime.spi.IValue;

public abstract class AbstractColumnFacade
extends AbstractFacade
implements IColumn {
    private IValue value = null;

    public AbstractColumnFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public String getName() {
        return (String)Util.invokeMethod(this.getTarget(), "getName", new Class[0], new Object[0]);
    }

    public Integer getSqlTypeCode() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getSqlTypeCode", new Class[0], new Object[0]);
    }

    public String getSqlType() {
        return (String)Util.invokeMethod(this.getTarget(), "getSqlType", new Class[0], new Object[0]);
    }

    public int getLength() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getLength", new Class[0], new Object[0]);
    }

    public int getDefaultLength() {
        return (Integer)Util.getFieldValue(this.getColumnClass(), "DEFAULT_LENGTH", null);
    }

    public int getPrecision() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getPrecision", new Class[0], new Object[0]);
    }

    public int getDefaultPrecision() {
        return (Integer)Util.getFieldValue(this.getColumnClass(), "DEFAULT_PRECISION", null);
    }

    public int getScale() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getScale", new Class[0], new Object[0]);
    }

    public int getDefaultScale() {
        return (Integer)Util.getFieldValue(this.getColumnClass(), "DEFAULT_SCALE", null);
    }

    public boolean isNullable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isNullable", new Class[0], new Object[0]);
    }

    public IValue getValue() {
        Object targetValue = this.getTargetValue();
        if (targetValue != null && this.value == null) {
            this.value = this.getFacadeFactory().createValue(targetValue);
        }
        return this.value;
    }

    public boolean isUnique() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isUnique", new Class[0], new Object[0]);
    }

    public String getSqlType(IConfiguration configuration) {
        Object dialectTarget;
        String result = null;
        String dialectKey = (String)Util.getFieldValue(this.getEnvironmentClass(), "DIALECT", null);
        String dialectName = configuration.getProperty(dialectKey);
        if (dialectName != null && (dialectTarget = Util.invokeMethod(this.getDialectFactoryClass(), "buildDialect", new Class[]{Properties.class}, new Object[]{configuration.getProperties()})) != null) {
            Object configurationTarget = Util.invokeMethod(configuration, "getTarget", new Class[0], new Object[0]);
            Object mappingTarget = Util.invokeMethod(configurationTarget, "buildMapping", new Class[0], new Object[0]);
            result = (String)Util.invokeMethod(this.getTarget(), "getSqlType", new Class[]{this.getDialectClass(), this.getMappingClass()}, new Object[]{dialectTarget, mappingTarget});
        }
        return result;
    }

    public void setSqlType(String sqlType) {
        Util.invokeMethod(this.getTarget(), "setSqlType", new Class[]{String.class}, new Object[]{sqlType});
    }

    protected Class<?> getColumnClass() {
        return Util.getClass(this.getColumnClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getDialectClass() {
        return Util.getClass(this.getDialectClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getDialectFactoryClass() {
        return Util.getClass(this.getDialectFactoryClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getEnvironmentClass() {
        return Util.getClass(this.getEnvironmentClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getMappingClass() {
        return Util.getClass(this.getMappingClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getColumnClassName() {
        return "org.hibernate.mapping.Column";
    }

    protected String getDialectClassName() {
        return "org.hibernate.dialect.Dialect";
    }

    protected String getDialectFactoryClassName() {
        return "org.hibernate.dialect.resolver.DialectFactory";
    }

    protected String getEnvironmentClassName() {
        return "org.hibernate.cfg.Environment";
    }

    protected String getMappingClassName() {
        return "org.hibernate.engine.spi.Mapping";
    }

    private Object getTargetValue() {
        return Util.invokeMethod(this.getTarget(), "getValue", new Class[0], new Object[0]);
    }
}

