/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.views.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanOperationInfo;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.HasName;
import org.jboss.tools.jmx.core.IConnectionCategory;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.MBeanAttributeInfoWrapper;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.core.MBeanOperationInfoWrapper;
import org.jboss.tools.jmx.core.MBeanUtils;
import org.jboss.tools.jmx.core.tree.DomainNode;
import org.jboss.tools.jmx.core.tree.ErrorRoot;
import org.jboss.tools.jmx.core.tree.MBeansNode;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.PropertyNode;
import org.jboss.tools.jmx.ui.ImageProvider;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.UIExtensionManager;
import org.jboss.tools.jmx.ui.internal.JMXImages;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerContentProvider;

public class MBeanExplorerLabelProvider
extends LabelProvider {
    private static ArrayList<MBeanExplorerLabelProvider> instances = new ArrayList();
    private static HashMap<String, Image> images = new HashMap();

    public MBeanExplorerLabelProvider() {
        instances.add(this);
    }

    public void dispose() {
        instances.remove((Object)this);
        if (instances.isEmpty()) {
            for (Image o : images.values()) {
                if (o == null) continue;
                o.dispose();
            }
            IConnectionProvider[] providers = ExtensionManager.getProviders();
            int j = 0;
            while (j < providers.length) {
                UIExtensionManager.ConnectionProviderUI ui = UIExtensionManager.getConnectionProviderUI(providers[j].getId());
                if (ui != null) {
                    ui.dispose();
                }
                ++j;
            }
        }
        super.dispose();
    }

    public String getText(Object obj) {
        MBeanInfoWrapper wrapper;
        DomainNode node;
        UIExtensionManager.ConnectionCategoryUI ui;
        if (obj instanceof HasName) {
            HasName hasName = (HasName)obj;
            return hasName.getName();
        }
        if (obj instanceof MBeanExplorerContentProvider.ProviderCategory && (ui = UIExtensionManager.getConnectionCategoryUI(((MBeanExplorerContentProvider.ProviderCategory)obj).getId())) != null) {
            return ui.getName();
        }
        if (obj instanceof IConnectionCategory) {
            return ((IConnectionCategory)obj).getCategoryId();
        }
        if (obj instanceof IConnectionWrapper) {
            IConnectionProvider provider = ((IConnectionWrapper)obj).getProvider();
            return this.getLabelForConnection(provider, (IConnectionWrapper)obj);
        }
        if (obj instanceof MBeanExplorerContentProvider.DelayProxy) {
            return Messages.Loading;
        }
        if (obj instanceof ErrorRoot) {
            return Messages.ErrorLoading;
        }
        if (obj instanceof DomainNode) {
            node = (DomainNode)obj;
            return node.getDomain();
        }
        if (obj instanceof ObjectNameNode) {
            node = (ObjectNameNode)obj;
            return node.getValue();
        }
        if (obj instanceof PropertyNode) {
            node = (PropertyNode)obj;
            return node.getValue();
        }
        if (obj instanceof MBeanInfoWrapper) {
            wrapper = (MBeanInfoWrapper)obj;
            return wrapper.getObjectName().toString();
        }
        if (obj instanceof MBeanOperationInfoWrapper) {
            wrapper = (MBeanOperationInfoWrapper)obj;
            return MBeanUtils.prettySignature((MBeanOperationInfo)wrapper.getMBeanOperationInfo());
        }
        if (obj instanceof MBeanAttributeInfoWrapper) {
            wrapper = (MBeanAttributeInfoWrapper)obj;
            return wrapper.getMBeanAttributeInfo().getName();
        }
        return obj.toString();
    }

    private Image getImageForProvider(IConnectionProvider provider) {
        UIExtensionManager.ConnectionProviderUI ui = UIExtensionManager.getConnectionProviderUI(provider.getId());
        if (ui != null) {
            if (!images.containsKey(ui.getId()) || images.get(ui.getId()).isDisposed()) {
                images.put(ui.getId(), ui.getImageDescriptor().createImage());
            }
            return images.get(ui.getId());
        }
        return null;
    }

    private Image getImageForConnection(IConnectionProvider provider, IConnectionWrapper connection) {
        Image i;
        UIExtensionManager.ConnectionProviderUI ui = UIExtensionManager.getConnectionProviderUI(provider.getId());
        if (ui != null && ui.hasLabelProvider() && (i = ui.getImageForConnection(connection)) != null) {
            return i;
        }
        return this.getImageForProvider(provider);
    }

    private String getLabelForConnection(IConnectionProvider provider, IConnectionWrapper connection) {
        String s;
        UIExtensionManager.ConnectionProviderUI ui = UIExtensionManager.getConnectionProviderUI(provider.getId());
        if (ui != null && ui.hasLabelProvider() && (s = ui.getTextForConnection(connection)) != null) {
            return s;
        }
        return provider.getName(connection);
    }

    private Image getImageForCategory(MBeanExplorerContentProvider.ProviderCategory provider) {
        UIExtensionManager.ConnectionCategoryUI ui = UIExtensionManager.getConnectionCategoryUI(provider.getId());
        if (ui != null) {
            if (!images.containsKey(ui.getId()) || images.get(ui.getId()).isDisposed()) {
                images.put(ui.getId(), ui.getImageDescriptor().createImage());
            }
            return images.get(ui.getId());
        }
        return null;
    }

    public Image getImage(Object obj) {
        ImageProvider provider;
        Image answer;
        if (obj instanceof ImageProvider && (answer = (provider = (ImageProvider)obj).getImage()) != null) {
            return answer;
        }
        if (obj instanceof MBeanExplorerContentProvider.ProviderCategory) {
            return this.getImageForCategory((MBeanExplorerContentProvider.ProviderCategory)obj);
        }
        if (obj instanceof IConnectionProvider) {
            return this.getImageForProvider((IConnectionProvider)obj);
        }
        if (obj instanceof IConnectionWrapper) {
            provider = ((IConnectionWrapper)obj).getProvider();
            return this.getImageForConnection((IConnectionProvider)provider, (IConnectionWrapper)obj);
        }
        if (obj instanceof MBeanExplorerContentProvider.DelayProxy) {
            return null;
        }
        if (obj instanceof ErrorRoot) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (obj instanceof MBeansNode) {
            return JMXImages.get("org.jboss.tools.jmx.ui.mbeans.png");
        }
        if (obj instanceof DomainNode) {
            return JMXImages.get("org.jboss.tools.jmx.ui.library_obj.gif");
        }
        if (obj instanceof ObjectNameNode) {
            return JMXImages.get("org.jboss.tools.jmx.ui.jmeth_obj.gif");
        }
        if (obj instanceof PropertyNode) {
            return JMXImages.get("org.jboss.tools.jmx.ui.package_obj.gif");
        }
        if (obj instanceof MBeanInfoWrapper) {
            return JMXImages.get("org.jboss.tools.jmx.ui.jmeth_obj.gif");
        }
        if (obj instanceof MBeanAttributeInfoWrapper) {
            return JMXImages.get("org.jboss.tools.jmx.ui.field_public_obj.gif");
        }
        if (obj instanceof MBeanOperationInfoWrapper) {
            return JMXImages.get("org.jboss.tools.jmx.ui.methpub_obj.gif");
        }
        String imageKey = "IMG_OBJ_ELEMENTS";
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }
}

