/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;

public class ConverterHyperlink
extends AbstractHyperlink {
    protected void doHyperlink(IRegion region) {
        XModel xModel = this.getXModel();
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        Properties p = new Properties();
        String converterID = this.getConverterID(region);
        IFile file = this.getFile();
        if (file != null) {
            p.put("file", file);
        }
        provider.getList(xModel, "jsf.open.convertor", converterID, p);
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    private String getConverterID(IRegion region) {
        String converterID = null;
        if (this.getDocument() != null && region != null) {
            try {
                converterID = this.getDocument().get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException x) {
                JSFModelPlugin.getPluginLog().logError("Cannot get convertor id", (Throwable)x);
            }
        }
        return converterID;
    }

    public String getHyperlinkText() {
        String converterId = this.getConverterID(this.getHyperlinkRegion());
        if (converterId == null) {
            return MessageFormat.format(Messages.OpenA, JSFTextExtMessages.Converter);
        }
        return MessageFormat.format(JSFTextExtMessages.OpenConverterForId, converterId);
    }
}

