/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JsfJSPTagNameHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String JSF_JSP_TAG_NAME_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSF_JSP_TAG_NAME";
    private String[] JSF_PROJECT_NATURES = new String[]{"org.jboss.tools.jsf.jsfnature"};

    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            IRegion r = this.getRegion(document, offset);
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = JSF_JSP_TAG_NAME_PARTITION;
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(r.getOffset(), r.getLength(), axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, int offset, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            IFile documentFile = smw.getFile();
            if (documentFile == null) {
                return false;
            }
            IProject project = documentFile.getProject();
            if (project == null) {
                return false;
            }
            if (EclipseResourceUtil.getModelNature((IProject)project) != null) {
                int i = 0;
                while (i < this.JSF_PROJECT_NATURES.length) {
                    if (project.getNature(this.JSF_PROJECT_NATURES[i]) != null) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }
        catch (CoreException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return false;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof IDOMElement)) {
                return null;
            }
            IDOMElement elem = (IDOMElement)n;
            String tagName = elem.getTagName();
            int start = Utils.getValueStart((Node)elem);
            int nameStart = start + (elem.isEndTag() ? "</" : "<").length();
            int nameEnd = nameStart + tagName.length();
            if (nameStart > offset || nameEnd <= offset) {
                return null;
            }
            Region region = new Region(nameStart, nameEnd - nameStart);
            return region;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, int offset) {
        return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)offset)) + "/";
    }
}

