/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.actions;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jboss.tools.jsf.ui.editor.edit.JSFEditPart;
import org.jboss.tools.jsf.ui.editor.edit.LinkEditPart;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.commands.JSFCompoundCommand;

public class JSFCommandFactory {
    private static final String DELETE_ACTION = "DeleteActions.Delete";
    private static final String COPY_ACTION = "CopyActions.Copy";
    private static final String CUT_ACTION = "CopyActions.Cut";
    private static final String PASTE_ACTION = "CopyActions.Paste";

    private static Command createCommand(List objects, String commandPath) {
        Object source = null;
        if (objects.isEmpty()) {
            return null;
        }
        if (objects.get(0) instanceof JSFEditPart || objects.get(0) instanceof LinkEditPart) {
            JSFCompoundCommand compoundCmd = new JSFCompoundCommand(commandPath);
            int i = 0;
            while (i < objects.size()) {
                source = null;
                if (objects.get(i) instanceof JSFEditPart) {
                    source = ((IJSFElement)((JSFEditPart)objects.get(i)).getModel()).getSource();
                } else if (objects.get(i) instanceof LinkEditPart) {
                    source = ((IJSFElement)((LinkEditPart)objects.get(i)).getModel()).getSource();
                }
                if (source != null) {
                    compoundCmd.add(source);
                }
                ++i;
            }
            return compoundCmd;
        }
        return null;
    }

    public static Command createDeleteCommand(List objects) {
        return JSFCommandFactory.createCommand(objects, DELETE_ACTION);
    }

    public static Command createCopyCommand(List objects) {
        return JSFCommandFactory.createCommand(objects, COPY_ACTION);
    }

    public static Command createCutCommand(List objects) {
        return JSFCommandFactory.createCommand(objects, CUT_ACTION);
    }

    public static Command createPasteCommand(List objects) {
        return JSFCommandFactory.createCommand(objects, PASTE_ACTION);
    }
}

