/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.jboss.tools.jsf.ui.editor.edit.PageEditPart;
import org.jboss.tools.jsf.ui.editor.figures.NodeFigure;
import org.jboss.tools.jsf.ui.editor.figures.xpl.FixedConnectionAnchor;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IPage;

public class PageFigure
extends NodeFigure
implements HandleBounds {
    private static final Dimension SIZE = new Dimension(56, 100);
    private PageEditPart pagePart;
    private IPage page;
    private IGroup group;

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public void init(int number) {
        if (number == 0) {
            number = 1;
        }
        int i = 0;
        while (i < number) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = 8 + 16 * i;
            c.offsetH = -2;
            c.leftToRight = false;
            this.connectionAnchors.put(String.valueOf(i + 1) + "_OUT", c);
            this.outputConnectionAnchors.addElement(c);
            ++i;
        }
    }

    public void addConnectionAnchor(int number) {
        if (number == 1) {
            return;
        }
        FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
        c.offsetV = 8 + 16 * (number - 1);
        c.offsetH = -2;
        c.leftToRight = false;
        this.connectionAnchors.put(String.valueOf(number) + "_OUT", c);
        this.outputConnectionAnchors.addElement(c);
    }

    public void removeConnectionAnchor() {
        if (this.outputConnectionAnchors.size() == 1) {
            return;
        }
        this.outputConnectionAnchors.remove(this.outputConnectionAnchors.size() - 1);
    }

    public void removeAllConnectionAnchor() {
        this.outputConnectionAnchors.removeAllElements();
    }

    public PageFigure(PageEditPart pagePart) {
        this.pagePart = pagePart;
        this.page = pagePart.getPageModel();
        this.group = (IGroup)this.page.getParentJSFElement();
        this.setOpaque(false);
        this.init(this.page.getLinkList().size());
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(2, 0, 2, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        int width = r.width;
        int height = r.height;
        if (this.pagePart.getSelected() == 2 || this.pagePart.getSelected() == 1) {
            if (this.page.hasErrors()) {
                g.setBackgroundColor(errorSelected);
            } else if (this.group.isPattern()) {
                g.setBackgroundColor(pattSelected);
            } else if (this.group.isConfirmed()) {
                g.setBackgroundColor(brownColor);
            } else {
                g.setBackgroundColor(lightGrayColor);
            }
        } else if (this.page.hasErrors()) {
            g.setBackgroundColor(errorColor);
        } else if (this.group.isPattern()) {
            g.setBackgroundColor(lightBlueColor);
        } else if (this.group.isConfirmed()) {
            g.setBackgroundColor(yellowColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillRectangle(0, 0, width, height);
        if (this.pagePart.getSelected() == 2 || this.pagePart.getSelected() == 1) {
            if (this.page.hasErrors()) {
                g.setForegroundColor(errorBorder);
            } else if (this.group.isPattern()) {
                g.setForegroundColor(pattBorder);
            } else if (this.group.isConfirmed()) {
                g.setForegroundColor(borderColor);
            } else {
                g.setForegroundColor(darkGrayColor);
            }
            g.drawRectangle(0, 0, width - 1, height - 1);
            if (this.group.getPageList().indexOf(this.page) == 0) {
                g.drawLine(0, 1, width - 1, 1);
            }
        }
    }
}

