/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.form;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.XChildrenTableStructuredAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredEditor;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.FacesConfigEditorMessages;

public class LocaleConfigForm
extends ExpandableForm {
    private XAttributeSupport support;
    private XModelObject xmo;
    private TableStructuredEditor tableEditor;
    private XChildrenTableStructuredAdapter tableAdapter;
    private IPropertyEditor defaultLocale;
    private IWidgetSettings settings = WhiteSettings.getWhite();
    private long timeStamp = -1L;

    public LocaleConfigForm() {
        this.support = new XAttributeSupport(this.settings);
        this.setCollapsable(Boolean.TRUE);
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.tableEditor != null) {
            this.tableEditor.dispose();
        }
        this.tableEditor = null;
        if (this.tableAdapter != null) {
            this.tableAdapter.dispose();
        }
        this.tableAdapter = null;
    }

    protected Control createClientArea(Composite parent, IWidgetSettings settings) {
        Control[] control;
        GridData gd;
        Label label;
        Composite composite = new Composite(parent, 0);
        settings.setupControl((Control)composite);
        GridLayout layout = new GridLayout(2, Boolean.FALSE.booleanValue());
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        String description = FacesConfigEditorMessages.LOCALECONFIGFORM_DESCRIPTION;
        if (description != null && description.length() > 0) {
            label = new Label(composite, 64);
            settings.setupControl((Control)label);
            label.setText(description);
            gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        if (this.xmo == null) {
            return composite;
        }
        if (this.defaultLocale != null) {
            ExtendedFieldEditor f = this.defaultLocale.getFieldEditor(composite);
            control = ((IFieldEditor)f).getControls(composite);
            gd = new GridData();
            control[0].setLayoutData((Object)gd);
            gd = new GridData(768);
            control[1].setLayoutData((Object)gd);
            this.support.registerFieldEditor(this.defaultLocale.getAttributeName(), (FieldEditor)f);
        }
        label = new Label(composite, 64);
        settings.setupControl((Control)label);
        label.setText(FacesConfigEditorMessages.LOCALECONFIGFORM_SUPPORTEDLOCAL_TITLE);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        control = ((IFieldEditor)this.tableEditor.getFieldEditor(composite)).getControls(composite);
        control[0].dispose();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        control[1].setLayoutData((Object)gd);
        return composite;
    }

    public void initialize(Object model) {
        this.setHeadingText(FacesConfigEditorMessages.LOCALECONFIGFORM_HEADER);
        XModelObject current = (XModelObject)model;
        this.xmo = current.getFileType() == 1 ? current.getChildByPath("application/Locale Config") : current.getChildByPath("Locale Config");
        if (this.xmo == null) {
            JsfUiPlugin.getPluginLog().logInfo("Error to create form " + FacesConfigEditorMessages.LOCALECONFIGFORM_HEADER + ". Model object cannot be null.", (Throwable)new Exception());
            return;
        }
        this.model = this.xmo.getModel();
        this.support.init(this.xmo);
        this.support.setAutoStore(Boolean.TRUE.booleanValue());
        this.defaultLocale = this.support.getPropertyEditorByName("default-locale");
        this.tableAdapter = new XChildrenTableStructuredAdapter();
        this.tableAdapter.setShownEntities(new String[]{"JSFSupportedLocale"});
        this.tableAdapter.getActionMapping().clear();
        this.tableAdapter.getActionMapping().put("ADD_ACTION", "CreateActions.AddSupportedLocale");
        this.tableAdapter.getActionMapping().put("REMOVE_ACTION", "DeleteActions.Delete");
        this.tableAdapter.getActionMapping().put("EDIT_ACTION", "Properties.Properties");
        this.tableAdapter.getActionMapping().put("UP_ACTION", "%internal%");
        this.tableAdapter.getActionMapping().put("DOWN_ACTION", "%internal%");
        this.tableAdapter.setShownProperties(new String[]{"supported-locale"});
        this.tableAdapter.setColumnLabels(new String[]{FacesConfigEditorMessages.LOCALECONFIGFORM_SUPPORTEDLOCAL_COLUMN_LABEL});
        this.tableAdapter.setWidths(new int[]{100});
        this.tableAdapter.setModelObject(this.xmo);
        this.tableEditor = new TableStructuredEditor(this.settings);
        this.tableEditor.setLabelText("");
        this.tableEditor.setInput((Object)this.tableAdapter);
    }

    public void update() {
        long ts;
        long l = ts = this.xmo == null ? -1L : this.xmo.getTimeStamp();
        if (ts == this.timeStamp) {
            return;
        }
        this.timeStamp = ts;
        if (this.support != null) {
            this.support.load();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.support != null) {
            this.support.setEnabled(enabled);
        }
    }

    public boolean doGlobalAction(String actionId) {
        return this.support.doGlobalAction(actionId);
    }
}

