/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.jbpm.template;

import java.util.ArrayList;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.w3c.dom.Node;

public class JBPMDataCell
extends VpeAbstractTemplate {
    private static final String JBPM_CELL_HEADER_TYPE = "vpe-jbpm-cell-header";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        return new VpeCreationData((nsIDOMNode)visualDocument.createElement("tr"));
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        nsIDOMElement trElement = (nsIDOMElement)data.getNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        nsIDOMElement cellHeader = this.getCellHeader(trElement);
        if (cellHeader != null) {
            trElement.removeChild((nsIDOMNode)cellHeader);
        }
        nsIDOMNodeList children = trElement.getChildNodes();
        ArrayList<nsIDOMNode> childNodeList = new ArrayList<nsIDOMNode>(0);
        int i = 0;
        while ((long)i < children.getLength()) {
            childNodeList.add(children.item((long)i));
            ++i;
        }
        while (trElement.hasChildNodes()) {
            trElement.removeChild(trElement.getFirstChild());
        }
        nsIDOMElement secondColumn = visualDocument.createElement("td");
        secondColumn.setAttribute("style", this.computeColumnStyleValue());
        if (cellHeader != null) {
            trElement.appendChild((nsIDOMNode)cellHeader);
        }
        trElement.appendChild((nsIDOMNode)secondColumn);
        for (nsIDOMNode nsIDOMNode2 : childNodeList) {
            secondColumn.appendChild(nsIDOMNode2);
        }
    }

    private nsIDOMElement getCellHeader(nsIDOMElement trElement) {
        nsIDOMNodeList headsList = trElement.getElementsByTagName("th");
        if (headsList == null) {
            return null;
        }
        int i = 0;
        while ((long)i < headsList.getLength()) {
            nsIDOMElement element = (nsIDOMElement)headsList.item((long)i).queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            if (JBPM_CELL_HEADER_TYPE.equals(element.getAttribute("vpe-pseudo-type"))) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private String computeColumnStyleValue() {
        StringBuilder builder = new StringBuilder("");
        builder.append("background:none repeat scroll 0 0 #DDDDDD;");
        builder.append("border-bottom:1px solid #000000;");
        builder.append("border-collapse:collapse;");
        builder.append("color:#000000;");
        builder.append("font-size:11px;");
        builder.append("text-align:left;");
        builder.append("text-decoration:none;");
        builder.append("white-space:nowrap;");
        builder.append("width:260px;");
        builder.append("padding:3px 5px;");
        builder.append("margin:0");
        return builder.toString();
    }
}

