/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.el.refactoring;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELObject;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.MessagePropertyELSegment;
import org.jboss.tools.jsf.el.refactoring.ELRenameProcessor;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.refactoring.RefactorSearcher;

public class RenameMessagePropertyProcessor
extends ELRenameProcessor {
    IFile file;
    MessagePropertyELSegment segment;
    MessagePropertySearcher searcher;

    public RenameMessagePropertyProcessor(IFile file, MessagePropertyELSegment segment) {
        super(file, segment.getToken().getText());
        this.file = file;
        this.segment = segment;
        this.setOldName(segment.getToken().getText());
        this.searcher = new MessagePropertySearcher(file, segment.getToken().getText());
    }

    @Override
    protected RefactorSearcher getSearcher() {
        return this.searcher;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.status = new RefactoringStatus();
        this.rootChange = new CompositeChange(ElCoreMessages.RENAME_MESSAGE_PROPERTY_PROCESSOR_TITLE);
        this.renameELVariable(pm, this.file);
        return this.status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.validateSegment()) {
            result.addFatalError(NLS.bind((String)ElCoreMessages.RENAME_MESSAGE_PROPERTY_PROCESSOR_CAN_NOT_FIND_MESSAGE_PROPERTY, (Object)this.getOldName()));
        }
        return result;
    }

    private boolean validateSegment() {
        if (this.segment.getMessageBundleResource() == null) {
            return false;
        }
        if (this.segment.getToken() == null) {
            return false;
        }
        return this.segment.getBaseName() != null && this.segment.getBaseName().length() != 0;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.rootChange;
    }

    public Object[] getElements() {
        return new String[]{this.getNewName()};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return ElCoreMessages.RENAME_MESSAGE_PROPERTY_PROCESSOR_TITLE;
    }

    public boolean isApplicable() throws CoreException {
        return this.getNewName() != null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REF_PARTICIPANT;
    }

    private void renameELVariable(IProgressMonitor pm, IFile file) {
        TextFileChange change = this.getChange(this.segment.getMessageBundleResource());
        ReplaceEdit edit = new ReplaceEdit(this.segment.getMessagePropertySourceReference().getStartPosition(), this.segment.getMessagePropertySourceReference().getLength(), this.getNewName());
        change.addEdit((TextEdit)edit);
        this.getSearcher().findELReferences(pm);
    }

    class MessagePropertySearcher
    extends ELRenameProcessor.ELSearcher {
        public MessagePropertySearcher(IFile file, String oldName) {
            super(RenameMessagePropertyProcessor.this, file, oldName);
        }

        protected boolean searchInCach(IFile file, boolean outOfSync) {
            ELContext context = PageContextFactory.createPageContext((IFile)file);
            if (context == null) {
                return true;
            }
            ELReference[] references = context.getELReferences();
            ELResolver[] resolvers = context.getElResolvers();
            ELReference[] eLReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ELReference reference = eLReferenceArray[n2];
                int offset = reference.getStartPosition();
                ELExpression[] eLExpressionArray = reference.getEl();
                int n3 = eLExpressionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ELExpression operand = eLExpressionArray[n4];
                    ELResolver[] eLResolverArray = resolvers;
                    int n5 = resolvers.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ELResolver resolver = eLResolverArray[n6];
                        ELResolution resolution = resolver.resolve(context, operand, offset);
                        if (resolution != null) {
                            List segments = resolution.findSegmentsByMessageProperty(RenameMessagePropertyProcessor.this.segment.getBaseName(), this.propertyName);
                            if (!segments.isEmpty() && outOfSync) {
                                return false;
                            }
                            for (ELSegment segment : segments) {
                                this.match(file, offset + segment.getSourceReference().getStartPosition(), segment.getSourceReference().getLength());
                            }
                        }
                        ++n6;
                    }
                    for (ELObject child : operand.getChildren()) {
                        if (!(child instanceof ELExpression)) continue;
                        ELResolver[] eLResolverArray2 = resolvers;
                        int n7 = resolvers.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            ELResolver resolver = eLResolverArray2[n8];
                            ELResolution resolution = resolver.resolve(context, (ELExpression)child, offset);
                            if (resolution != null) {
                                List segments = resolution.findSegmentsByMessageProperty(RenameMessagePropertyProcessor.this.segment.getBaseName(), this.propertyName);
                                if (!segments.isEmpty() && outOfSync) {
                                    return false;
                                }
                                for (ELSegment segment : segments) {
                                    this.match(file, offset + segment.getSourceReference().getStartPosition(), segment.getSourceReference().getLength());
                                }
                            }
                            ++n8;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
    }
}

