/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.refactoring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.refactoring.RefactoringChangesFactory;
import org.jboss.tools.jsf.messages.JSFUIMessages;

public class JSf2MoveParticipant
extends MoveParticipant {
    private IProject project;
    private Map<String, String> urisMap;
    private static boolean isMoveContainer = true;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.project != null) {
            return RefactoringChangesFactory.createRenameURIChanges((IResource)this.project, this.urisMap);
        }
        return null;
    }

    public String getName() {
        return JSFUIMessages.Refactoring_JSF_2_resources;
    }

    protected boolean initialize(Object element) {
        Object object;
        if (!(element instanceof IContainer) && !(element instanceof IFile)) {
            return false;
        }
        IContainer container = null;
        isMoveContainer = true;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            container = file.getParent();
            isMoveContainer = false;
        } else {
            container = (IContainer)element;
        }
        if (JSf2MoveParticipant.checkResourceContainerPath(container.getFullPath()) && (object = this.getArguments().getDestination()) instanceof IContainer) {
            if (container.getProject() != ((IContainer)object).getProject()) {
                return false;
            }
            if (JSf2MoveParticipant.checkDistContainerPath(((IContainer)object).getFullPath())) {
                this.project = container.getProject();
                this.urisMap = JSf2MoveParticipant.invokePossibleURIs(container, (IContainer)object);
                return true;
            }
        }
        return false;
    }

    public static boolean checkDistContainerPath(IPath fullPath) {
        String[] segments = fullPath.segments();
        return segments.length > 2 && segments[2].equals("resources");
    }

    public static Map<String, String> invokePossibleURIs(IContainer srcContainer, IContainer distContainer) {
        return JSf2MoveParticipant.invokePossibleURIs(srcContainer, distContainer.getFullPath(), isMoveContainer);
    }

    public static Map<String, String> invokePossibleURIs(IContainer srcContainer, IPath distPath, boolean isMoveContainer) {
        String newFirstURIPart = JSf2MoveParticipant.createJSF2URIFromPath(distPath);
        String oldFirstURIPart = JSf2MoveParticipant.createJSF2URIFromPath(srcContainer.getFullPath());
        if (isMoveContainer) {
            oldFirstURIPart = oldFirstURIPart.substring(0, oldFirstURIPart.lastIndexOf(47));
        }
        HashSet<String> oldURIs = new HashSet<String>();
        JSf2MoveParticipant.invokeOldPossibleURIs(srcContainer, oldURIs);
        HashMap<String, String> urisMap = new HashMap<String, String>();
        for (String oldURI : oldURIs) {
            urisMap.put(oldURI, String.valueOf(newFirstURIPart) + oldURI.replaceFirst(oldFirstURIPart, ""));
        }
        return urisMap;
    }

    private static void invokeOldPossibleURIs(IContainer srcContainer, Set<String> uris) {
        uris.add(JSf2MoveParticipant.createJSF2URIFromPath(srcContainer.getFullPath()));
        try {
            IResource[] children = srcContainer.members();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IContainer) {
                        JSf2MoveParticipant.invokeOldPossibleURIs((IContainer)children[i], uris);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static boolean checkResourceContainerPath(IPath path) {
        String[] segments = path.segments();
        return segments.length > 3 && segments[2].equals("resources");
    }

    private static String createJSF2URIFromPath(IPath path) {
        StringBuilder uri = new StringBuilder("");
        String[] segments = path.segments();
        if (segments.length > 3 && segments[2].equals("resources")) {
            int i = 3;
            while (i < segments.length) {
                uri.append("/" + segments[i]);
                ++i;
            }
        }
        uri.insert(0, "http://java.sun.com/jsf/composite");
        return uri.toString();
    }
}

