/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.JSFPreference;
import org.jboss.tools.jsf.model.FileFacesConfigImpl;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.helpers.JSFProcessHelper;

public class ProcessAdopt
implements XAdoptManager,
JSFConstants {
    static String ADOPTABLE_JSP = ".FileJSP.FileHTML.FileXHTML.FileXML.";

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (this.isAdoptableJSP(target, object)) {
            this.adoptJSP(target, object, p);
        } else if (this.isAdoptableItem(target, object)) {
            this.adoptItem(target, object, p);
        }
    }

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        if (this.isAdoptableJSP(target, object)) {
            return true;
        }
        return this.isAdoptableItem(target, object);
    }

    private boolean isAdoptableJSP(XModelObject target, XModelObject object) {
        String entity = object.getModelEntity().getName();
        if (ADOPTABLE_JSP.indexOf("." + entity + ".") >= 0) {
            String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
            if (target.getModelEntity().getName().startsWith("FacesConfig")) {
                target = target.getChildByPath("process");
            }
            return JSFProcessHelper.getHelper(target).getPage(path) == null;
        }
        return false;
    }

    private void adoptJSP(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (target.getModelEntity().getName().startsWith("FacesConfig")) {
            target = target.getChildByPath("process");
        }
        this.addRuleByPageAdopt(target, object, p);
    }

    private void addRuleByPageAdopt(XModelObject process, XModelObject page, Properties p) throws XModelException {
        String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)page);
        XModelObject group = JSFProcessHelper.getHelper(process).getPage(path);
        if (group != null) {
            return;
        }
        boolean doNotCreateEmptyRule = "yes".equals(JSFPreference.DO_NOT_CREATE_EMPTY_RULE.getValue());
        group = JSFProcessHelper.getHelper(process).findOrCreateGroup(path, null);
        ProcessAdopt.setShape(group, p);
        if (doNotCreateEmptyRule) {
            group.setAttributeValue("persistent", "true");
            group.setModified(true);
        } else {
            XModelObject rules = process.getParent().getChildByPath("Navigation Rules");
            String ruleEntity = FileFacesConfigImpl.getNavigationRuleEntity(rules);
            XModelObject rule = rules.getModel().createModelObject(ruleEntity, null);
            rule.setAttributeValue("from-view-id", path);
            DefaultCreateHandler.addCreatedObject((XModelObject)rules, (XModelObject)rule, (Properties)p);
        }
    }

    public static void setShape(XModelObject group, Properties p) {
        String y;
        String x = p == null ? null : p.getProperty("process.mouse.x");
        String string = y = p == null ? null : p.getProperty("process.mouse.y");
        if (x != null && y != null) {
            group.setAttributeValue("shape", x + "," + y + ",0,0");
        }
    }

    private boolean isAdoptableItem(XModelObject target, XModelObject object) {
        return "JSFProcessGroup".equals(object.getModelEntity().getName());
    }

    private void adoptItem(XModelObject target, XModelObject object, Properties p) {
        p.put("sample", object);
        XActionInvoker.invoke((String)"CreateActions.AddRule", (XModelObject)target, (Properties)p);
    }
}

