/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.pattern;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;
import org.jboss.tools.jsf.web.pattern.PatternLoader;

public class PostfixUrlPattern
implements JSFUrlPattern {
    protected String postfix = ".jsf";
    protected String[] fileExtensions = PatternLoader.DEFAULT_SUFFIXES;

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public void setFileSuffixes(String[] fileExtentions) {
        this.fileExtensions = fileExtentions;
    }

    @Override
    public boolean matches(String path) {
        return path.endsWith(this.postfix);
    }

    @Override
    public boolean isJSFUrl(String path) {
        if (path.endsWith(this.postfix)) {
            return true;
        }
        String[] stringArray = this.fileExtensions;
        int n = this.fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileSuffix = stringArray[n2];
            if (path.endsWith(fileSuffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getJSFPath(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        List<String> ps = this.getJSFPaths(url);
        return ps.isEmpty() ? url : ps.get(0);
    }

    @Override
    public List<String> getJSFPaths(String url) {
        ArrayList<String> jsfPathsList = new ArrayList<String>();
        if (url != null && url.length() > 0) {
            if (url.endsWith(this.postfix)) {
                String[] stringArray = this.fileExtensions;
                int n = this.fileExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    jsfPathsList.add(String.valueOf(url.substring(0, url.length() - this.postfix.length())) + extension);
                    ++n2;
                }
            } else {
                jsfPathsList.add(url);
            }
        }
        return jsfPathsList;
    }

    @Override
    public String getJSFUrl(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (!path.endsWith(this.postfix)) {
            int dot = path.lastIndexOf(46);
            if (dot >= 0) {
                path = path.substring(0, dot);
            }
            path = String.valueOf(path) + this.postfix;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public String toString() {
        return "PostfixUrlPattern:" + this.postfix;
    }
}

