/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation.jsf2.action;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.web.validation.jsf2.action.JSF2CompositeAttrsProposal;
import org.jboss.tools.jsf.web.validation.jsf2.action.JSF2CompositeComponentProposal;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSF2ComponentResolutionGenerator
implements IMarkerResolutionGenerator2 {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            int messageId = this.getMessageID(marker);
            if (messageId == -1) {
                return new IMarkerResolution[0];
            }
            IFile file = (IFile)marker.getResource();
            Integer attribute = (Integer)marker.getAttribute("charStart");
            if (attribute == null) {
                return new IMarkerResolution[0];
            }
            int start = attribute;
            IModelManager manager = StructuredModelManager.getModelManager();
            if (manager == null) return new IMarkerResolution[0];
            IStructuredModel model = null;
            try {
                model = manager.getModelForRead(file);
                if (!(model instanceof IDOMModel)) return new IMarkerResolution[0];
                Node node = Utils.findNodeForOffset((IDOMNode)((IDOMModel)model).getDocument(), (int)start);
                String tagName = node.getLocalName();
                String attrName = "";
                if (node instanceof IDOMAttr) {
                    attrName = node.getLocalName();
                    node = ((IDOMAttr)node).getOwnerElement();
                    tagName = node.getLocalName();
                }
                if (messageId == 1) {
                    IMarkerResolution[] iMarkerResolutionArray = new IMarkerResolution[]{new JSF2CompositeComponentProposal(marker.getResource(), this.getComponentPath(node), tagName, this.getAttributes(node))};
                    return iMarkerResolutionArray;
                }
                if (messageId != 2) return new IMarkerResolution[0];
                IMarkerResolution[] iMarkerResolutionArray = new IMarkerResolution[]{new JSF2CompositeAttrsProposal(marker.getResource(), this.getComponentPath(node), tagName, this.getAttributes(node), attrName)};
                return iMarkerResolutionArray;
            }
            catch (CoreException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                return new IMarkerResolution[0];
            }
            catch (IOException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                return new IMarkerResolution[0];
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        catch (CoreException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return new IMarkerResolution[0];
    }

    private String getComponentPath(Node node) {
        String uriString = node.getNamespaceURI();
        String relativeLocation = uriString.replaceFirst("http://java.sun.com/jsf/composite", "");
        String nodeName = node.getLocalName();
        String path = String.valueOf(relativeLocation) + "/" + nodeName + ".xhtml";
        return path;
    }

    private String[] getAttributes(Node node) {
        NamedNodeMap nm = node.getAttributes();
        String[] attributes = new String[nm.getLength()];
        int i = 0;
        while (i < nm.getLength()) {
            attributes[i] = nm.item(i).getLocalName();
            ++i;
        }
        return attributes;
    }

    private int getMessageID(IMarker marker) throws CoreException {
        Integer attribute = (Integer)marker.getAttribute("JSF2_message_id");
        if (attribute != null) {
            return attribute;
        }
        return -1;
    }

    public boolean hasResolutions(IMarker marker) {
        if (marker.exists()) {
            try {
                return this.getMessageID(marker) >= 0;
            }
            catch (CoreException ex) {
                JSFModelPlugin.getDefault().logError(ex);
            }
        }
        return false;
    }
}

