/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.jboss.tools.jst.web.ui.internal.css.common.CSSStyleRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.common.StyleAttribyteContainer;
import org.jboss.tools.jst.web.ui.internal.css.common.StyleContainer;
import org.jboss.tools.jst.web.ui.internal.css.common.StyleElementRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSConstants;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class CSSStyleManager {
    public static final String STYLE_TAG_NAME = "style";
    public static final String STYLE_ATTRIBUTE_NAME = "style";

    public static StyleContainer recognizeCSSStyle(Object node) {
        StyleContainer container = null;
        if (node instanceof ICSSNode) {
            CSSStyleRule styleRule = CSSStyleManager.getStyleRule((ICSSNode)node);
            if (styleRule != null) {
                container = new CSSStyleRuleContainer(styleRule);
            }
        } else if (node instanceof Element || node instanceof Attr) {
            Element selectedElement = null;
            selectedElement = node instanceof Attr ? ((Attr)node).getOwnerElement() : (Element)node;
            if (CSSStyleManager.isSuitableElement(selectedElement)) {
                container = new StyleAttribyteContainer(selectedElement);
            }
        }
        return container;
    }

    public static StyleContainer recognizeCSSStyle(ISelection selection) {
        Text styleText;
        Node parentNode;
        Object selectedObject;
        StyleContainer container = null;
        if (selection instanceof IStructuredSelection && (container = CSSStyleManager.recognizeCSSStyle(selectedObject = ((IStructuredSelection)selection).getFirstElement())) == null && selectedObject instanceof Text && selection instanceof ITextSelection && (parentNode = (styleText = (Text)selectedObject).getParentNode()) != null && "style".equalsIgnoreCase(parentNode.getNodeName())) {
            int offset = CSSStyleManager.getRelationalOffset(styleText, ((ITextSelection)selection).getOffset());
            CSSStyleSheet sheet = CSSStyleManager.getSheet(parentNode);
            ICSSNode node = CSSStyleManager.getNode(sheet, offset);
            CSSStyleRule styleRule = CSSStyleManager.getStyleRule(node);
            if (styleRule != null) {
                container = new StyleElementRuleContainer(styleText, styleRule);
            }
        }
        return container;
    }

    private static CSSStyleSheet getSheet(Node styleContainer) {
        INodeNotifier notifier;
        IStyleSheetAdapter adapter;
        if (styleContainer instanceof INodeNotifier && (adapter = (IStyleSheetAdapter)(notifier = (INodeNotifier)styleContainer).getAdapterFor(IStyleSheetAdapter.class)) != null) {
            return (CSSStyleSheet)adapter.getSheet();
        }
        return null;
    }

    private static ICSSNode getNode(CSSStyleSheet sheet, int offset) {
        ICSSModel model = ((ICSSDocument)sheet).getModel();
        if (model != null) {
            return (ICSSNode)model.getIndexedRegion(offset);
        }
        return null;
    }

    private static boolean isSuitableElement(Element element) {
        return element instanceof ElementCSSInlineStyle && CSSStyleManager.isAttributeAvailable(element, "style");
    }

    private static CSSStyleRule getStyleRule(ICSSNode node) {
        while (node != null) {
            if (node instanceof CSSStyleRule) {
                return (CSSStyleRule)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private static int getRelationalOffset(Node basicNode, int absoluteOffset) {
        return absoluteOffset - ((IndexedRegion)basicNode).getStartOffset();
    }

    private static boolean isAttributeAvailable(Element element, String attrName) {
        CMNamedNodeMap map;
        CMElementDeclaration decl;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        return modelQuery != null && (decl = modelQuery.getCMElementDeclaration(element)) != null && (CMAttributeDeclaration)(map = decl.getAttributes()).getNamedItem(attrName) != null;
    }

    public static Map<String, String> getStyleAttributes(String styleString) {
        Map<String, String> styleMap = Collections.emptyMap();
        if (styleString != null && styleString.length() > 0) {
            String[] styles;
            styleMap = new HashMap<String, String>();
            String[] stringArray = styles = styleString.split(";");
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                String styleElement = stringArray[n2];
                String[] styleElementParts = styleElement.trim().split(":");
                if (styleElementParts.length == 2 && Util.searchInElement(styleElementParts[0], CSSConstants.CSS_STYLES_MAP)) {
                    styleMap.put(styleElementParts[0], styleElementParts[1]);
                }
                ++n2;
            }
        }
        return styleMap;
    }
}

