/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.common;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNodeList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.jboss.tools.jst.web.ui.internal.css.common.StyleContainer;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;

public class CSSStyleRuleContainer
extends StyleContainer {
    private CSSStyleRule styleRule;

    public CSSStyleRuleContainer(CSSStyleRule styleRule) {
        this.styleRule = styleRule;
    }

    @Override
    public void applyStyleAttributes(Map<String, String> attributes) {
        CSSStyleDeclaration declaration = this.styleRule.getStyle();
        if (attributes != null) {
            if (attributes.size() == 0 && declaration.getLength() > 0) {
                declaration.setCssText("");
            } else {
                for (Map.Entry<String, String> me : attributes.entrySet()) {
                    if (me.getValue() == null || me.getValue().length() == 0) {
                        declaration.removeProperty(me.getKey());
                        continue;
                    }
                    if (me.getValue().equals(declaration.getPropertyValue(me.getKey()))) continue;
                    declaration.setProperty(me.getKey(), me.getValue(), "");
                }
            }
        }
    }

    @Override
    public Map<String, String> getStyleAttributes() {
        CSSStyleDeclaration declaration = this.styleRule.getStyle();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        int i = 0;
        while (i < declaration.getLength()) {
            String propperty = declaration.item(i);
            String value = declaration.getPropertyValue(propperty);
            styleMap.put(propperty, value);
            ++i;
        }
        return styleMap;
    }

    @Override
    public Object getStyleObject() {
        return this.styleRule;
    }

    @Override
    public void addNodeListener(INodeAdapter adapter) {
        ICSSStyleDeclaration declaration = (ICSSStyleDeclaration)this.styleRule.getStyle();
        this.addNodeAdapter(declaration, adapter);
        this.addNodeListenersForChildren(declaration, adapter);
    }

    private void addNodeListenersForChildren(Object node, INodeAdapter adapter) {
        if (!(node instanceof ICSSNode)) {
            return;
        }
        ICSSNode cssNode = (ICSSNode)node;
        ICSSNodeList nodeList = cssNode.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            ICSSNode cssChildNode = nodeList.item(i);
            this.addNodeAdapter(cssChildNode, adapter);
            this.addNodeListenersForChildren(cssChildNode, adapter);
            ++i;
        }
    }

    private void removeNodeListenersForChildren(Object node, INodeAdapter adapter) {
        if (!(node instanceof ICSSNode)) {
            return;
        }
        ICSSNode cssNode = (ICSSNode)node;
        ICSSNodeList nodeList = cssNode.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            ICSSNode cssChildNode = nodeList.item(i);
            this.removeNodeAdapter(cssChildNode, adapter);
            this.removeNodeListenersForChildren(cssChildNode, adapter);
            ++i;
        }
    }

    @Override
    public void removeNodelListener(INodeAdapter adapter) {
        ICSSStyleDeclaration declaration = (ICSSStyleDeclaration)this.styleRule.getStyle();
        this.removeNodeAdapter(declaration, adapter);
        this.removeNodeListenersForChildren(declaration, adapter);
    }

    @Override
    public boolean isValid() {
        String text = this.styleRule.getCssText();
        return text == null || text.endsWith("}");
    }
}

